/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.AutoValue_FactoryDescriptor;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.Key;
import com.google.auto.factory.processor.PackageAndClass;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProviderField;
import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class FactoryDescriptor {
    private static final CharMatcher INVALID_IDENTIFIER_CHARACTERS = new CharMatcher(){

        public boolean matches(char c) {
            return !Character.isJavaIdentifierPart(c);
        }
    };

    FactoryDescriptor() {
    }

    abstract PackageAndClass name();

    abstract ImmutableSet<AnnotationMirror> annotations();

    abstract TypeMirror extendingType();

    abstract ImmutableSet<TypeMirror> implementingTypes();

    abstract boolean publicType();

    abstract ImmutableSet<FactoryMethodDescriptor> methodDescriptors();

    abstract ImmutableSet<ImplementationMethodDescriptor> implementationMethodDescriptors();

    abstract boolean allowSubclasses();

    abstract ImmutableMap<Key, ProviderField> providers();

    final AutoFactoryDeclaration declaration() {
        return ((FactoryMethodDescriptor)this.methodDescriptors().iterator().next()).declaration();
    }

    static FactoryDescriptor create(PackageAndClass name, ImmutableSet<AnnotationMirror> annotations, TypeMirror extendingType, ImmutableSet<TypeMirror> implementingTypes, boolean publicType, ImmutableSet<FactoryMethodDescriptor> methodDescriptors, ImmutableSet<ImplementationMethodDescriptor> implementationMethodDescriptors, boolean allowSubclasses) {
        ImmutableSetMultimap.Builder parametersForProviders = ImmutableSetMultimap.builder();
        for (FactoryMethodDescriptor descriptor : methodDescriptors) {
            for (Parameter parameter : descriptor.providedParameters()) {
                parametersForProviders.put((Object)parameter.key(), (Object)parameter);
            }
        }
        ImmutableMap.Builder providersBuilder = ImmutableMap.builder();
        UniqueNameSet uniqueNames = new UniqueNameSet();
        parametersForProviders.build().asMap().forEach((key, parameters) -> {
            switch (parameters.size()) {
                case 0: {
                    throw new AssertionError();
                }
                case 1: {
                    Parameter parameter = (Parameter)Iterables.getOnlyElement((Iterable)parameters);
                    providersBuilder.put(key, (Object)ProviderField.create(uniqueNames.getUniqueName(parameter.name() + "Provider"), key, parameter.nullable()));
                    break;
                }
                default: {
                    String providerName = uniqueNames.getUniqueName(INVALID_IDENTIFIER_CHARACTERS.replaceFrom((CharSequence)key.toString(), '_') + "Provider");
                    Optional<AnnotationMirror> nullable = parameters.stream().map(Parameter::nullable).flatMap(Streams::stream).findFirst();
                    providersBuilder.put(key, (Object)ProviderField.create(providerName, key, nullable));
                }
            }
        });
        ImmutableBiMap<FactoryMethodDescriptor, ImplementationMethodDescriptor> duplicateMethodDescriptors = FactoryDescriptor.createDuplicateMethodDescriptorsBiMap(methodDescriptors, implementationMethodDescriptors);
        ImmutableSet<FactoryMethodDescriptor> deduplicatedMethodDescriptors = FactoryDescriptor.getDeduplicatedMethodDescriptors(methodDescriptors, duplicateMethodDescriptors);
        ImmutableSet deduplicatedImplementationMethodDescriptors = Sets.difference(implementationMethodDescriptors, (Set)duplicateMethodDescriptors.values()).immutableCopy();
        return new AutoValue_FactoryDescriptor(name, annotations, extendingType, implementingTypes, publicType, deduplicatedMethodDescriptors, (ImmutableSet<ImplementationMethodDescriptor>)deduplicatedImplementationMethodDescriptors, allowSubclasses, (ImmutableMap<Key, ProviderField>)providersBuilder.build());
    }

    private static ImmutableBiMap<FactoryMethodDescriptor, ImplementationMethodDescriptor> createDuplicateMethodDescriptorsBiMap(ImmutableSet<FactoryMethodDescriptor> factoryMethodDescriptors, ImmutableSet<ImplementationMethodDescriptor> implementationMethodDescriptors) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        block0: for (FactoryMethodDescriptor factoryMethodDescriptor : factoryMethodDescriptors) {
            for (ImplementationMethodDescriptor implementationMethodDescriptor : implementationMethodDescriptors) {
                boolean areDuplicateMethodDescriptors = FactoryDescriptor.areDuplicateMethodDescriptors(factoryMethodDescriptor, implementationMethodDescriptor);
                if (!areDuplicateMethodDescriptors) continue;
                builder.put((Object)factoryMethodDescriptor, (Object)implementationMethodDescriptor);
                continue block0;
            }
        }
        return builder.build();
    }

    private static ImmutableSet<FactoryMethodDescriptor> getDeduplicatedMethodDescriptors(ImmutableSet<FactoryMethodDescriptor> methodDescriptors, ImmutableBiMap<FactoryMethodDescriptor, ImplementationMethodDescriptor> duplicateMethodDescriptors) {
        ImmutableSet.Builder deduplicatedMethodDescriptors = ImmutableSet.builder();
        for (FactoryMethodDescriptor methodDescriptor : methodDescriptors) {
            ImplementationMethodDescriptor duplicateMethodDescriptor = (ImplementationMethodDescriptor)duplicateMethodDescriptors.get((Object)methodDescriptor);
            FactoryMethodDescriptor newMethodDescriptor = duplicateMethodDescriptor != null ? methodDescriptor.toBuilder().overridingMethod(true).publicMethod(duplicateMethodDescriptor.publicMethod()).returnType(duplicateMethodDescriptor.returnType()).exceptions((Iterable<? extends TypeMirror>)duplicateMethodDescriptor.exceptions()).build() : methodDescriptor;
            deduplicatedMethodDescriptors.add((Object)newMethodDescriptor);
        }
        return deduplicatedMethodDescriptors.build();
    }

    private static boolean areDuplicateMethodDescriptors(FactoryMethodDescriptor factory, ImplementationMethodDescriptor implementation) {
        if (!factory.name().equals(implementation.name())) {
            return false;
        }
        return Iterables.elementsEqual((Iterable)Iterables.transform(factory.passedParameters(), Parameter::type), (Iterable)Iterables.transform(implementation.passedParameters(), Parameter::type));
    }

    private static class UniqueNameSet {
        private final Set<String> uniqueNames = new HashSet<String>();

        private UniqueNameSet() {
        }

        String getUniqueName(CharSequence base) {
            String name = base.toString();
            int differentiator = 2;
            while (!this.uniqueNames.add(name)) {
                name = base.toString() + differentiator;
                ++differentiator;
            }
            return name;
        }
    }
}

