/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMediaHttpUploaderProgressListener
implements MediaHttpUploaderProgressListener {
    private static final Logger LOG = LoggerFactory.getLogger(MediaHttpUploaderProgressListener.class);
    private static final double BYTES_IN_MB = 1048576.0;
    private final long minLoggingInterval;
    private final String name;
    private long startTime;
    private long prevTime;
    private long prevUploadedBytes;

    public LoggingMediaHttpUploaderProgressListener(String name, long minLoggingInterval) {
        this.name = name;
        this.minLoggingInterval = minLoggingInterval;
    }

    public void progressChanged(MediaHttpUploader uploader) throws IOException {
        this.progressChanged(LOG, uploader.getUploadState(), uploader.getNumBytesUploaded(), System.currentTimeMillis());
    }

    void progressChanged(Logger log, MediaHttpUploader.UploadState uploadState, long bytesUploaded, long currentTime) {
        switch (uploadState) {
            case INITIATION_STARTED: {
                this.startTime = currentTime;
                this.prevTime = currentTime;
                log.debug("Uploading: {}", (Object)this.name);
                break;
            }
            case MEDIA_IN_PROGRESS: {
                if (currentTime <= this.prevTime + this.minLoggingInterval) break;
                double averageRate = (double)bytesUploaded / 1048576.0 / ((double)(currentTime - this.startTime) / 1000.0);
                double currentRate = (double)(bytesUploaded - this.prevUploadedBytes) / 1048576.0 / ((double)(currentTime - this.prevTime) / 1000.0);
                log.debug(String.format("Uploading: %s Average Rate: %.3f MiB/s, Current Rate: %.3f MiB/s, Total: %.3f MiB", this.name, averageRate, currentRate, (double)bytesUploaded / 1048576.0));
                this.prevTime = currentTime;
                this.prevUploadedBytes = bytesUploaded;
                break;
            }
            case MEDIA_COMPLETE: {
                log.debug("Finished Uploading: {}", (Object)this.name);
                break;
            }
        }
    }
}

