/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.client.util.Preconditions;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.datastore.AggregationResult;
import com.google.cloud.datastore.models.ExplainMetrics;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AggregationResults
implements Iterable<AggregationResult> {
    private final List<AggregationResult> aggregationResults;
    private final Timestamp readTime;
    private final ExplainMetrics explainMetrics;

    @BetaApi
    public AggregationResults(List<AggregationResult> aggregationResults, Timestamp readTime, ExplainMetrics explainMetrics) {
        Preconditions.checkNotNull(aggregationResults, (Object)"Aggregation results cannot be null");
        Preconditions.checkNotNull((Object)readTime, (Object)"readTime cannot be null");
        this.aggregationResults = aggregationResults;
        this.readTime = readTime;
        this.explainMetrics = explainMetrics;
    }

    public AggregationResults(List<AggregationResult> aggregationResults, Timestamp readTime) {
        this(aggregationResults, readTime, null);
    }

    @Override
    public Iterator<AggregationResult> iterator() {
        return this.aggregationResults.iterator();
    }

    public int size() {
        return this.aggregationResults.size();
    }

    @BetaApi
    public Optional<ExplainMetrics> getExplainMetrics() {
        return Optional.ofNullable(this.explainMetrics);
    }

    @InternalApi
    public AggregationResult get(int index) {
        return this.aggregationResults.get(index);
    }

    public Timestamp getReadTime() {
        return this.readTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationResults that = (AggregationResults)o;
        return Objects.equals(this.aggregationResults, that.aggregationResults) && Objects.equals(this.readTime, that.readTime) && Objects.equals(this.explainMetrics, that.explainMetrics);
    }

    public int hashCode() {
        return Objects.hash(this.aggregationResults, this.readTime, this.explainMetrics);
    }
}

