/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.execution.response;

import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.datastore.AggregationResult;
import com.google.cloud.datastore.AggregationResults;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.execution.response.ResponseTransformer;
import com.google.cloud.datastore.models.ExplainMetrics;
import com.google.datastore.v1.RunAggregationQueryResponse;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@InternalApi
public class AggregationQueryResponseTransformer
implements ResponseTransformer<RunAggregationQueryResponse, AggregationResults> {
    @Override
    public AggregationResults transform(RunAggregationQueryResponse response) {
        Timestamp readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getBatch().getReadTime());
        List aggregationResults = response.getBatch().getAggregationResultsList().stream().map(aggregationResult -> new AggregationResult(this.transformValues((com.google.datastore.v1.AggregationResult)aggregationResult))).collect(Collectors.toCollection(LinkedList::new));
        ExplainMetrics explainMetrics = null;
        if (response.hasExplainMetrics()) {
            explainMetrics = new ExplainMetrics(response.getExplainMetrics());
        }
        return new AggregationResults(aggregationResults, readTime, explainMetrics);
    }

    private Map<String, Value<?>> transformValues(com.google.datastore.v1.AggregationResult aggregationResult) {
        return aggregationResult.getAggregatePropertiesMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry((String)entry.getKey(), Value.fromPb((com.google.datastore.v1.Value)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

