/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.datastore.models.ExecutionStats;
import com.google.cloud.datastore.models.PlanSummary;
import com.google.common.base.Objects;
import java.util.Optional;

@BetaApi
public class ExplainMetrics {
    private final PlanSummary planSummary;
    private ExecutionStats executionStats;

    @InternalApi
    public ExplainMetrics(com.google.datastore.v1.ExplainMetrics proto) {
        if (proto.hasExecutionStats()) {
            this.executionStats = new ExecutionStats(proto.getExecutionStats());
        }
        this.planSummary = new PlanSummary(proto.getPlanSummary());
    }

    public PlanSummary getPlanSummary() {
        return this.planSummary;
    }

    public Optional<ExecutionStats> getExecutionStats() {
        return Optional.ofNullable(this.executionStats);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExplainMetrics)) {
            return false;
        }
        ExplainMetrics that = (ExplainMetrics)o;
        return Objects.equal((Object)this.planSummary, (Object)that.planSummary) && Objects.equal((Object)this.executionStats, (Object)that.executionStats);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.planSummary, this.executionStats});
    }
}

