/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.generativeai.ContentMaker;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import com.google.cloud.vertexai.generativeai.ResponseStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ChatSession {
    private final GenerativeModel model;
    private final Optional<ChatSession> rootChatSession;
    private List<Content> history = new ArrayList<Content>();
    private int previousHistorySize = 0;
    private Optional<ResponseStream<GenerateContentResponse>> currentResponseStream;
    private Optional<GenerateContentResponse> currentResponse;

    public ChatSession(GenerativeModel model) {
        this(model, Optional.empty());
    }

    private ChatSession(GenerativeModel model, Optional<ChatSession> rootChatSession) {
        Preconditions.checkNotNull((Object)model, (Object)"model should not be null");
        this.model = model;
        this.rootChatSession = rootChatSession;
        this.currentResponseStream = Optional.empty();
        this.currentResponse = Optional.empty();
    }

    public ChatSession withGenerationConfig(GenerationConfig generationConfig) {
        ChatSession rootChat = this.rootChatSession.orElse(this);
        ChatSession newChatSession = new ChatSession(this.model.withGenerationConfig(generationConfig), Optional.of(rootChat));
        newChatSession.history = this.history;
        newChatSession.previousHistorySize = this.previousHistorySize;
        return newChatSession;
    }

    public ChatSession withSafetySettings(List<SafetySetting> safetySettings) {
        ChatSession rootChat = this.rootChatSession.orElse(this);
        ChatSession newChatSession = new ChatSession(this.model.withSafetySettings(safetySettings), Optional.of(rootChat));
        newChatSession.history = this.history;
        newChatSession.previousHistorySize = this.previousHistorySize;
        return newChatSession;
    }

    public ChatSession withTools(List<Tool> tools) {
        ChatSession rootChat = this.rootChatSession.orElse(this);
        ChatSession newChatSession = new ChatSession(this.model.withTools(tools), Optional.of(rootChat));
        newChatSession.history = this.history;
        newChatSession.previousHistorySize = this.previousHistorySize;
        return newChatSession;
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(String text) throws IOException {
        return this.sendMessageStream(ContentMaker.fromString(text));
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(Content content) throws IOException {
        ResponseStream<GenerateContentResponse> respStream;
        this.checkLastResponseAndEditHistory();
        this.history.add(content);
        try {
            respStream = this.model.generateContentStream(this.history);
        }
        catch (IOException e) {
            this.revertHistory();
            throw e;
        }
        this.setCurrentResponseStream(Optional.of(respStream));
        return respStream;
    }

    public GenerateContentResponse sendMessage(String text) throws IOException {
        return this.sendMessage(ContentMaker.fromString(text));
    }

    public GenerateContentResponse sendMessage(Content content) throws IOException {
        GenerateContentResponse response;
        this.checkLastResponseAndEditHistory();
        this.history.add(content);
        try {
            response = this.model.generateContent(this.history);
        }
        catch (IOException e) {
            this.revertHistory();
            throw e;
        }
        this.setCurrentResponse(Optional.of(response));
        return response;
    }

    private void revertHistory() {
        this.history.subList(this.getPreviousHistorySize(), this.history.size()).clear();
    }

    private void checkLastResponseAndEditHistory() {
        this.getCurrentResponse().ifPresent(currentResponse -> {
            this.setCurrentResponse(Optional.empty());
            this.checkFinishReasonAndEditHistory((GenerateContentResponse)currentResponse);
            this.history.add(ResponseHandler.getContent(currentResponse));
            this.setPreviousHistorySize(this.history.size());
        });
        this.getCurrentResponseStream().ifPresent(responseStream -> {
            if (!responseStream.isConsumed()) {
                throw new IllegalStateException("Response stream is not consumed");
            }
            this.setCurrentResponseStream(Optional.empty());
            GenerateContentResponse response = ResponseHandler.aggregateStreamIntoResponse(responseStream);
            this.checkFinishReasonAndEditHistory(response);
            this.history.add(ResponseHandler.getContent(response));
            this.setPreviousHistorySize(this.history.size());
        });
    }

    private void checkFinishReasonAndEditHistory(GenerateContentResponse response) {
        Candidate.FinishReason finishReason = ResponseHandler.getFinishReason(response);
        if (finishReason != Candidate.FinishReason.STOP && finishReason != Candidate.FinishReason.MAX_TOKENS) {
            this.revertHistory();
            throw new IllegalStateException(String.format("The last round of conversation will not be added to history because response stream did not finish normally. Finish reason is %s.", finishReason));
        }
    }

    public ImmutableList<Content> getHistory() {
        try {
            this.checkLastResponseAndEditHistory();
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("The last round of conversation will not be added to history because")) {
                IllegalStateException modifiedExecption = new IllegalStateException("Rerun getHistory() to get cleaned history.");
                modifiedExecption.initCause(e);
                throw modifiedExecption;
            }
            throw e;
        }
        return ImmutableList.copyOf(this.history);
    }

    private int getPreviousHistorySize() {
        if (this.rootChatSession.isPresent()) {
            return this.rootChatSession.get().previousHistorySize;
        }
        return this.previousHistorySize;
    }

    private Optional<GenerateContentResponse> getCurrentResponse() {
        if (this.rootChatSession.isPresent()) {
            return this.rootChatSession.get().currentResponse;
        }
        return this.currentResponse;
    }

    private Optional<ResponseStream<GenerateContentResponse>> getCurrentResponseStream() {
        if (this.rootChatSession.isPresent()) {
            return this.rootChatSession.get().currentResponseStream;
        }
        return this.currentResponseStream;
    }

    public void setHistory(List<Content> history) {
        this.history = new ArrayList<Content>(history);
    }

    private void setPreviousHistorySize(int historySize) {
        this.previousHistorySize = historySize;
        if (this.rootChatSession.isPresent()) {
            this.rootChatSession.get().previousHistorySize = historySize;
        }
    }

    private void setCurrentResponse(Optional<GenerateContentResponse> response) {
        if (this.currentResponseStream.isPresent()) {
            throw new IllegalStateException("currentResponse and currentResponseStream cannot be set together");
        }
        if (this.rootChatSession.isPresent()) {
            this.rootChatSession.get().setCurrentResponse(response);
        } else {
            this.currentResponse = response;
        }
    }

    private void setCurrentResponseStream(Optional<ResponseStream<GenerateContentResponse>> responseStream) {
        if (this.currentResponse.isPresent()) {
            throw new IllegalStateException("currentResponseStream and currentResponse cannot be set together");
        }
        if (this.rootChatSession.isPresent()) {
            this.rootChatSession.get().setCurrentResponseStream(responseStream);
        } else {
            this.currentResponseStream = responseStream;
        }
    }
}

