/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.Transaction;
import com.google.datastore.v1.TransactionOptions;
import java.util.function.Supplier;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DatastoreTransactionManager
extends AbstractPlatformTransactionManager {
    private static final TransactionOptions READ_ONLY_OPTIONS = TransactionOptions.newBuilder().setReadOnly(TransactionOptions.ReadOnly.newBuilder().build()).build();
    private final Supplier<Datastore> datastore;

    public DatastoreTransactionManager(Supplier<Datastore> datastore) {
        this.datastore = datastore;
    }

    protected Object doGetTransaction() throws TransactionException {
        Tx tx = (Tx)TransactionSynchronizationManager.getResource((Object)this.datastore.get());
        if (tx != null && tx.transaction != null && tx.transaction.isActive()) {
            return tx;
        }
        tx = new Tx(this.datastore.get());
        return tx;
    }

    protected void doBegin(Object transactionObject, TransactionDefinition transactionDefinition) throws TransactionException {
        if (transactionDefinition.getIsolationLevel() != -1 && transactionDefinition.getIsolationLevel() != 8) {
            throw new IllegalStateException("DatastoreTransactionManager supports only isolation level TransactionDefinition.ISOLATION_DEFAULT or ISOLATION_SERIALIZABLE");
        }
        if (transactionDefinition.getPropagationBehavior() != 0) {
            throw new IllegalStateException("DatastoreTransactionManager supports only propagation behavior TransactionDefinition.PROPAGATION_REQUIRED");
        }
        Tx tx = (Tx)transactionObject;
        tx.transaction = transactionDefinition.isReadOnly() ? tx.datastore.newTransaction(READ_ONLY_OPTIONS) : tx.datastore.newTransaction();
        TransactionSynchronizationManager.bindResource((Object)tx.datastore, (Object)tx);
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        try {
            if (tx.transaction.isActive()) {
                tx.transaction.commit();
            } else {
                this.logger.debug((Object)"Transaction was not committed because it is no longer active.");
            }
        }
        catch (DatastoreException ex) {
            throw new TransactionSystemException("Cloud Datastore transaction failed to commit.", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        try {
            if (tx.transaction.isActive()) {
                tx.transaction.rollback();
            } else {
                this.logger.debug((Object)"Transaction was not rolled back because it is no longer active.");
            }
        }
        catch (DatastoreException ex) {
            throw new TransactionSystemException("Cloud Datastore transaction failed to rollback.", (Throwable)ex);
        }
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((Tx)transaction).transaction != null;
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Tx tx = (Tx)transaction;
        TransactionSynchronizationManager.unbindResource((Object)tx.datastore);
    }

    public static class Tx {
        private Transaction transaction;
        private Datastore datastore;

        public Tx(Datastore datastore) {
            this.datastore = datastore;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }

        public Datastore getDatastore() {
            return this.datastore;
        }
    }
}

