/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.mapping;

import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntity;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentProperty;
import com.google.cloud.spring.data.datastore.core.mapping.DiscriminatorField;
import com.google.cloud.spring.data.datastore.core.mapping.DiscriminatorValue;
import com.google.cloud.spring.data.datastore.core.mapping.Entity;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DatastorePersistentEntityImpl<T>
extends BasicPersistentEntity<T, DatastorePersistentProperty>
implements DatastorePersistentEntity<T> {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final Expression kindNameExpression;
    private final String classBasedKindName;
    private final Entity kind;
    private final DiscriminatorField discriminatorField;
    private final DiscriminatorValue discriminatorValue;
    private final DatastoreMappingContext datastoreMappingContext;
    private StandardEvaluationContext context;

    public DatastorePersistentEntityImpl(TypeInformation<T> information, DatastoreMappingContext datastoreMappingContext) {
        super(information);
        this.datastoreMappingContext = datastoreMappingContext;
        this.context = new StandardEvaluationContext();
        this.kind = (Entity)this.findAnnotation(Entity.class);
        this.discriminatorField = (DiscriminatorField)this.findAnnotation(DiscriminatorField.class);
        this.discriminatorValue = (DiscriminatorValue)this.findAnnotation(DiscriminatorValue.class);
        this.classBasedKindName = this.findKindName(information.getType());
        this.kindNameExpression = this.detectExpression();
    }

    protected boolean hasTableName() {
        return this.kind != null && StringUtils.hasText((String)this.kind.name());
    }

    private String findKindName(Class<?> rawType) {
        if (this.hasTableName()) {
            Assert.notNull((Object)this.kind, (String)"Kind unknown; check your @Entity declaration.");
            return this.kind.name();
        }
        return StringUtils.uncapitalize((String)rawType.getSimpleName());
    }

    @Nullable
    private Expression detectExpression() {
        if (!this.hasTableName()) {
            return null;
        }
        Expression expression = PARSER.parseExpression(this.kind.name(), ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    @Override
    public String kindName() {
        if (this.discriminatorValue != null && this.discriminatorField == null) {
            throw new DatastoreDataException("This class expects a discrimination field but none are designated: " + this.getType());
        }
        if (this.discriminatorValue != null && this.getType().getSuperclass() != Object.class) {
            return ((DatastorePersistentEntityImpl)this.datastoreMappingContext.getDatastorePersistentEntity(this.getType().getSuperclass())).getDiscriminationSuperclassPersistentEntity().kindName();
        }
        return this.kindNameExpression == null ? this.classBasedKindName : (String)this.kindNameExpression.getValue((EvaluationContext)this.context, String.class);
    }

    @Override
    public DatastorePersistentProperty getIdPropertyOrFail() {
        if (!this.hasIdProperty()) {
            throw new DatastoreDataException("An ID property was required but does not exist for the type: " + this.getType());
        }
        return (DatastorePersistentProperty)this.getIdProperty();
    }

    public void verify() {
        super.verify();
        this.initializeSubclassEntities();
        this.addEntityToDiscriminationFamily();
        this.checkDiscriminationValues();
    }

    private void checkDiscriminationValues() {
        Set<Class> otherMembers = DatastoreMappingContext.getDiscriminationFamily(this.getType());
        if (otherMembers != null) {
            for (Class other : otherMembers) {
                DatastorePersistentEntity<?> persistentEntity = this.datastoreMappingContext.getDatastorePersistentEntity(other);
                if (this.getDiscriminatorValue() == null || !this.getDiscriminatorValue().equals(persistentEntity.getDiscriminatorValue())) continue;
                throw new DatastoreDataException("More than one class in an inheritance hierarchy has the same DiscriminatorValue: " + this.getType() + " and " + other);
            }
        }
    }

    private void addEntityToDiscriminationFamily() {
        DatastorePersistentEntity parentEntity;
        Class parentClass = this.getType().getSuperclass();
        DatastorePersistentEntity datastorePersistentEntity = parentEntity = parentClass != Object.class ? (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(parentClass) : null;
        if (parentEntity != null && parentEntity.getDiscriminationFieldName() != null) {
            if (!parentEntity.getDiscriminationFieldName().equals(this.getDiscriminationFieldName())) {
                throw new DatastoreDataException("This class and its super class both have discrimination fields but they are different fields: " + this.getType() + " and " + parentClass);
            }
            DatastoreMappingContext.addDiscriminationClassConnection(parentClass, this.getType());
        }
    }

    @Override
    public String getDiscriminationFieldName() {
        return this.discriminatorField == null ? null : this.discriminatorField.field();
    }

    @Override
    public List<String> getCompatibleDiscriminationValues() {
        if (this.discriminatorValue == null) {
            return Collections.emptyList();
        }
        LinkedList<String> compatibleValues = new LinkedList<String>();
        compatibleValues.add(this.discriminatorValue.value());
        DatastorePersistentEntity persistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(this.getType().getSuperclass());
        if (persistentEntity != null) {
            List<String> compatibleDiscriminationValues = persistentEntity.getCompatibleDiscriminationValues();
            compatibleValues.addAll(compatibleDiscriminationValues);
        }
        return compatibleValues;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discriminatorValue == null ? null : this.discriminatorValue.value();
    }

    @Override
    public void doWithColumnBackedProperties(PropertyHandler<DatastorePersistentProperty> handler) {
        this.doWithProperties(datastorePersistentProperty -> {
            if (datastorePersistentProperty.isColumnBacked()) {
                handler.doWithPersistentProperty(datastorePersistentProperty);
            }
        });
    }

    @Override
    public void doWithDescendantProperties(PropertyHandler<DatastorePersistentProperty> handler) {
        this.doWithProperties(datastorePersistentProperty -> {
            if (datastorePersistentProperty.isDescendants()) {
                handler.doWithPersistentProperty(datastorePersistentProperty);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    private DatastorePersistentEntity getDiscriminationSuperclassPersistentEntity() {
        if (this.discriminatorField != null) {
            return this;
        }
        return ((DatastorePersistentEntityImpl)this.datastoreMappingContext.getDatastorePersistentEntity(this.getType().getSuperclass())).getDiscriminationSuperclassPersistentEntity();
    }

    private void initializeSubclassEntities() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this.getType()));
        for (BeanDefinition component : provider.findCandidateComponents(this.getType().getPackage().getName())) {
            try {
                this.datastoreMappingContext.getPersistentEntity(Class.forName(component.getBeanClassName()));
            }
            catch (ClassNotFoundException ex) {
                throw new DatastoreDataException("Could not find expected subclass for this entity: " + this.getType(), ex);
            }
        }
    }
}

