/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.ImageTarball;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.cloud.tools.jib.image.Image;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class WriteTarFileStep
implements AsyncStep<BuildResult>,
Callable<BuildResult> {
    private final ListeningExecutorService listeningExecutorService;
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final Path outputPath;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final BuildImageStep buildImageStep;
    private final ListenableFuture<BuildResult> listenableFuture;

    WriteTarFileStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Path outputPath, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.outputPath = outputPath;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = buildAndCacheApplicationLayerSteps;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(pullAndCacheBaseImageLayersStep).addStep(buildImageStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<BuildResult> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BuildResult call() throws ExecutionException, InterruptedException {
        return (BuildResult)AsyncDependencies.using(this.listeningExecutorService).addSteps((List)NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)).addSteps((List<? extends AsyncStep<?>>)this.buildAndCacheApplicationLayerSteps).addStep(NonBlockingSteps.get(this.buildImageStep)).whenAllSucceed(this::writeTarFile).get();
    }

    private BuildResult writeTarFile() throws ExecutionException, IOException {
        this.buildConfiguration.getEventHandlers().dispatch(LogEvent.progress("Building image to tar file..."));
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("writing to tar file", 1L);){
            Image image = NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep));
            Files.createDirectories(this.outputPath.getParent(), new FileAttribute[0]);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(FileOperations.newLockingOutputStream(this.outputPath));){
                new ImageTarball(image, this.buildConfiguration.getTargetImageConfiguration().getImage()).writeTo(outputStream);
            }
            BuildResult buildResult = BuildResult.fromImage(image, this.buildConfiguration.getTargetFormat());
            return buildResult;
        }
    }
}

