/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperNotFoundException;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperUnhandledServerUrlException;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;

public class CredentialRetrieverFactory {
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final ImageReference imageReference;
    private final Consumer<LogEvent> logger;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;

    public static CredentialRetrieverFactory forImage(ImageReference imageReference, Consumer<LogEvent> logger) {
        return new CredentialRetrieverFactory(imageReference, logger, DockerCredentialHelper::new);
    }

    public static CredentialRetrieverFactory forImage(ImageReference imageReference) {
        return new CredentialRetrieverFactory(imageReference, logEvent -> {}, DockerCredentialHelper::new);
    }

    @VisibleForTesting
    CredentialRetrieverFactory(ImageReference imageReference, Consumer<LogEvent> logger, DockerCredentialHelperFactory dockerCredentialHelperFactory) {
        this.imageReference = imageReference;
        this.logger = logger;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
    }

    public CredentialRetriever known(Credential credential, String credentialSource) {
        return () -> {
            this.logGotCredentialsFrom(credentialSource);
            return Optional.of(credential);
        };
    }

    public CredentialRetriever dockerCredentialHelper(String credentialHelper) {
        return this.dockerCredentialHelper(Paths.get(credentialHelper, new String[0]));
    }

    public CredentialRetriever dockerCredentialHelper(Path credentialHelper) {
        return () -> {
            this.logger.accept(LogEvent.info("Checking credentials from " + credentialHelper));
            try {
                return Optional.of(this.retrieveFromDockerCredentialHelper(credentialHelper));
            }
            catch (CredentialHelperUnhandledServerUrlException ex) {
                this.logger.accept(LogEvent.info("No credentials for " + this.imageReference.getRegistry() + " in " + credentialHelper));
                return Optional.empty();
            }
            catch (IOException ex) {
                throw new CredentialRetrievalException(ex);
            }
        };
    }

    public CredentialRetriever inferCredentialHelper() {
        ArrayList<String> inferredCredentialHelperSuffixes = new ArrayList<String>();
        for (String registrySuffix : COMMON_CREDENTIAL_HELPERS.keySet()) {
            if (!this.imageReference.getRegistry().endsWith(registrySuffix)) continue;
            String inferredCredentialHelperSuffix = (String)COMMON_CREDENTIAL_HELPERS.get((Object)registrySuffix);
            if (inferredCredentialHelperSuffix == null) {
                throw new IllegalStateException("No COMMON_CREDENTIAL_HELPERS should be null");
            }
            inferredCredentialHelperSuffixes.add(inferredCredentialHelperSuffix);
        }
        return () -> {
            for (String inferredCredentialHelperSuffix : inferredCredentialHelperSuffixes) {
                try {
                    return Optional.of(this.retrieveFromDockerCredentialHelper(Paths.get("docker-credential-" + inferredCredentialHelperSuffix, new String[0])));
                }
                catch (CredentialHelperNotFoundException | CredentialHelperUnhandledServerUrlException ex) {
                    if (ex.getMessage() == null) continue;
                    this.logger.accept(LogEvent.info(ex.getMessage()));
                    if (ex.getCause() == null || ex.getCause().getMessage() == null) continue;
                    this.logger.accept(LogEvent.info("  Caused by: " + ex.getCause().getMessage()));
                }
                catch (IOException ex) {
                    throw new CredentialRetrievalException(ex);
                }
            }
            return Optional.empty();
        };
    }

    public CredentialRetriever dockerConfig() {
        return this.dockerConfig(new DockerConfigCredentialRetriever(this.imageReference.getRegistry()));
    }

    public CredentialRetriever dockerConfig(Path dockerConfigFile) {
        return this.dockerConfig(new DockerConfigCredentialRetriever(this.imageReference.getRegistry(), dockerConfigFile));
    }

    @VisibleForTesting
    CredentialRetriever dockerConfig(DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        return () -> {
            try {
                Optional<Credential> dockerConfigCredentials = dockerConfigCredentialRetriever.retrieve(this.logger);
                if (dockerConfigCredentials.isPresent()) {
                    this.logger.accept(LogEvent.info("Using credentials from Docker config for " + this.imageReference.getRegistry()));
                    return dockerConfigCredentials;
                }
            }
            catch (IOException ex) {
                this.logger.accept(LogEvent.info("Unable to parse Docker config"));
            }
            return Optional.empty();
        };
    }

    private Credential retrieveFromDockerCredentialHelper(Path credentialHelper) throws CredentialHelperUnhandledServerUrlException, CredentialHelperNotFoundException, IOException {
        Credential credentials = this.dockerCredentialHelperFactory.create(this.imageReference.getRegistry(), credentialHelper).retrieve();
        this.logGotCredentialsFrom(credentialHelper.getFileName().toString());
        return credentials;
    }

    private void logGotCredentialsFrom(String credentialSource) {
        this.logger.accept(LogEvent.info("Using " + credentialSource + " for " + this.imageReference.getRegistry()));
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface DockerCredentialHelperFactory {
        public DockerCredentialHelper create(String var1, Path var2);
    }
}

