/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public class ImageLayers
implements Iterable<Layer> {
    private final ImmutableList<Layer> layers;
    private final ImmutableSet<DescriptorDigest> layerDigests;

    public static Builder builder() {
        return new Builder();
    }

    private ImageLayers(ImmutableList<Layer> layers, ImmutableSet<DescriptorDigest> layerDigests) {
        this.layers = layers;
        this.layerDigests = layerDigests;
    }

    public ImmutableList<Layer> getLayers() {
        return this.layers;
    }

    public int size() {
        return this.layers.size();
    }

    public boolean isEmpty() {
        return this.layers.isEmpty();
    }

    public Layer get(int index) {
        return (Layer)this.layers.get(index);
    }

    @Nullable
    public Layer get(DescriptorDigest digest) throws LayerPropertyNotFoundException {
        if (!this.has(digest)) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getBlobDescriptor().getDigest().equals(digest)) continue;
            return layer;
        }
        throw new IllegalStateException("Layer digest exists but layer not found");
    }

    public boolean has(DescriptorDigest digest) {
        return this.layerDigests.contains((Object)digest);
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.getLayers().iterator();
    }

    public static class Builder {
        private final List<Layer> layers = new ArrayList<Layer>();
        private final ImmutableSet.Builder<DescriptorDigest> layerDigestsBuilder = ImmutableSet.builder();
        private boolean removeDuplicates = false;

        public Builder add(Layer layer) throws LayerPropertyNotFoundException {
            this.layerDigestsBuilder.add((Object)layer.getBlobDescriptor().getDigest());
            this.layers.add(layer);
            return this;
        }

        public Builder addAll(ImageLayers layers) throws LayerPropertyNotFoundException {
            for (Layer layer : layers) {
                this.add(layer);
            }
            return this;
        }

        public Builder removeDuplicates() {
            this.removeDuplicates = true;
            return this;
        }

        public ImageLayers build() {
            if (!this.removeDuplicates) {
                return new ImageLayers(ImmutableList.copyOf(this.layers), this.layerDigestsBuilder.build());
            }
            LinkedHashSet dedupedButReversed = new LinkedHashSet(Lists.reverse(this.layers));
            ImmutableList deduped = ImmutableList.copyOf(dedupedButReversed).reverse();
            return new ImageLayers(deduped, this.layerDigestsBuilder.build());
        }
    }
}

