/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

class MojoCommon {
    static List<Path> getExtraDirectories(JibPluginConfiguration jibPluginConfiguration) {
        List<Path> paths = jibPluginConfiguration.getExtraDirectories();
        if (!paths.isEmpty()) {
            return paths;
        }
        MavenProject project = (MavenProject)Preconditions.checkNotNull((Object)jibPluginConfiguration.getProject());
        return Collections.singletonList(project.getBasedir().toPath().resolve("src").resolve("main").resolve("jib"));
    }

    @VisibleForTesting
    static Map<AbsoluteUnixPath, FilePermissions> convertPermissionsList(List<JibPluginConfiguration.PermissionConfiguration> permissionList) {
        HashMap<AbsoluteUnixPath, FilePermissions> permissionsMap = new HashMap<AbsoluteUnixPath, FilePermissions>();
        for (JibPluginConfiguration.PermissionConfiguration permission : permissionList) {
            if (!permission.getFile().isPresent() || !permission.getMode().isPresent()) {
                throw new IllegalArgumentException("Incomplete <permission> configuration; requires <file> and <mode> fields to be set");
            }
            AbsoluteUnixPath key = AbsoluteUnixPath.get(permission.getFile().get());
            FilePermissions value = FilePermissions.fromOctalString(permission.getMode().get());
            permissionsMap.put(key, value);
        }
        return permissionsMap;
    }

    private MojoCommon() {
    }
}

