/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="_skaffold-package-goals", requiresDirectInvocation=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageGoalsMojo
extends AbstractMojo {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-package-goals";
    @Nullable
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenExecutionPlan mavenExecutionPlan;
        Preconditions.checkNotNull((Object)this.lifecycleExecutor);
        Preconditions.checkNotNull((Object)this.session);
        try {
            mavenExecutionPlan = this.lifecycleExecutor.calculateExecutionPlan(this.session, new String[]{"package"});
        }
        catch (Exception ex) {
            throw new MojoExecutionException("failed to calculate execution plan", ex);
        }
        mavenExecutionPlan.getMojoExecutions().stream().filter(mojoExecution -> "package".equals(mojoExecution.getLifecyclePhase())).filter(mojoExecution -> "jib-maven-plugin".equals(mojoExecution.getPlugin().getArtifactId())).map(MojoExecution::getGoal).forEach(System.out::println);
    }
}

