/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import java.io.IOException;
import java.util.List;

public class ErrorResponseUtil {
    public static ErrorCodes getErrorCode(HttpResponseException httpResponseException) throws HttpResponseException {
        String errorContent = httpResponseException.getContent();
        if (errorContent == null) {
            throw httpResponseException;
        }
        try {
            String errorCodeString;
            ErrorResponseTemplate errorResponse = JsonTemplateMapper.readJson(errorContent, ErrorResponseTemplate.class);
            List<ErrorEntryTemplate> errors = errorResponse.getErrors();
            if (errors.size() == 1 && (errorCodeString = errors.get(0).getCode()) != null) {
                return ErrorCodes.valueOf(errorCodeString);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
        throw httpResponseException;
    }

    private ErrorResponseUtil() {
    }
}

