/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.OCIManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class ManifestPuller<T extends ManifestTemplate>
implements RegistryEndpointProvider<T> {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final String imageTag;
    private final Class<T> manifestTemplateClass;

    ManifestPuller(RegistryEndpointRequestProperties registryEndpointRequestProperties, String imageTag, Class<T> manifestTemplateClass) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.imageTag = imageTag;
        this.manifestTemplateClass = manifestTemplateClass;
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        if (this.manifestTemplateClass.equals(V21ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v1+json");
        }
        if (this.manifestTemplateClass.equals(V22ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v2+json");
        }
        if (this.manifestTemplateClass.equals(OCIManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.oci.image.manifest.v1+json");
        }
        return Arrays.asList("application/vnd.oci.image.manifest.v1+json", "application/vnd.docker.distribution.manifest.v2+json", "application/vnd.docker.distribution.manifest.v1+json");
    }

    @Override
    public T handleResponse(Response response) throws IOException, UnknownManifestFormatException {
        String jsonString = CharStreams.toString((Readable)new InputStreamReader(response.getBody(), StandardCharsets.UTF_8));
        return this.getManifestTemplateFromJson(jsonString);
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointRequestProperties.getImageName() + "/manifests/" + this.imageTag);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "pull image manifest for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + ":" + this.imageTag;
    }

    private T getManifestTemplateFromJson(String jsonString) throws IOException, UnknownManifestFormatException {
        ObjectNode node = (ObjectNode)new ObjectMapper().readValue(jsonString, ObjectNode.class);
        if (!node.has("schemaVersion")) {
            throw new UnknownManifestFormatException("Cannot find field 'schemaVersion' in manifest");
        }
        if (!this.manifestTemplateClass.equals(ManifestTemplate.class)) {
            return (T)((ManifestTemplate)JsonTemplateMapper.readJson(jsonString, this.manifestTemplateClass));
        }
        int schemaVersion = node.get("schemaVersion").asInt(-1);
        if (schemaVersion == -1) {
            throw new UnknownManifestFormatException("`schemaVersion` field is not an integer");
        }
        if (schemaVersion == 1) {
            return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, V21ManifestTemplate.class)));
        }
        if (schemaVersion == 2) {
            String mediaType = node.get("mediaType").asText();
            if ("application/vnd.docker.distribution.manifest.v2+json".equals(mediaType)) {
                return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, V22ManifestTemplate.class)));
            }
            if ("application/vnd.oci.image.manifest.v1+json".equals(mediaType)) {
                return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, OCIManifestTemplate.class)));
            }
            throw new UnknownManifestFormatException("Unknown mediaType: " + mediaType);
        }
        throw new UnknownManifestFormatException("Unknown schemaVersion: " + schemaVersion + " - only 1 and 2 are supported");
    }
}

