/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentBuilder;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementField;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.InjectionMethods;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SubcomponentWriter;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class AbstractComponentWriter
implements GeneratedComponentModel {
    protected final Elements elements;
    protected final DaggerTypes types;
    protected final Key.Factory keyFactory;
    protected final CompilerOptions compilerOptions;
    protected final ClassName name;
    protected final BindingGraph graph;
    protected final ImmutableMap<ComponentDescriptor, String> subcomponentNames;
    protected final TypeSpec.Builder component;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final UniqueNameSet componentMethodNames = new UniqueNameSet();
    private final ComponentBindingExpressions bindingExpressions;
    protected final ComponentRequirementFields componentRequirementFields;
    private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
    protected final List<MethodSpec> interfaceMethods = new ArrayList<MethodSpec>();
    private final BindingExpression.Factory bindingExpressionFactory;
    private final ComponentRequirementField.Factory componentRequirementFieldFactory;
    private final Map<Key, MethodSpec> membersInjectionMethods = new LinkedHashMap<Key, MethodSpec>();
    protected final MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
    private final OptionalFactories optionalFactories;
    private ComponentBuilder builder;
    private boolean done;
    private final ImmutableMap<ComponentRequirement, FieldSpec> builderFields;
    private ImmutableMap<Scope, MemberSelect> referenceReleasingProviderManagerFields;
    private static final int INITIALIZATIONS_PER_INITIALIZE_METHOD = 100;

    AbstractComponentWriter(DaggerTypes types, Elements elements, Key.Factory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph, ImmutableMap<ComponentDescriptor, String> subcomponentNames, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
        this.component = TypeSpec.classBuilder((ClassName)name);
        this.name = name;
        this.graph = graph;
        this.subcomponentNames = subcomponentNames;
        this.optionalFactories = optionalFactories;
        this.bindingExpressions = bindingExpressions;
        if (AbstractComponentWriter.hasBuilder(graph)) {
            this.builder = ComponentBuilder.create(name, graph, subcomponentNames, elements, types);
            this.builderFields = this.builder.builderFields();
        } else {
            this.builderFields = ImmutableMap.of();
        }
        this.componentRequirementFields = componentRequirementFields;
        this.bindingExpressionFactory = new BindingExpression.Factory(compilerOptions, name, this.componentFieldNames, bindingExpressions, componentRequirementFields, this, AbstractComponentWriter.childComponentNames(keyFactory, subcomponentNames), graph, types, elements, optionalFactories);
        this.componentRequirementFieldFactory = new ComponentRequirementField.Factory(this, this.componentFieldNames, name, this.builderFields);
    }

    private static ImmutableMap<BindingKey, String> childComponentNames(Key.Factory keyFactory, ImmutableMap<ComponentDescriptor, String> subcomponentNames) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        subcomponentNames.forEach((component, name) -> {
            if (component.builderSpec().isPresent()) {
                TypeMirror builderType = component.builderSpec().get().builderDefinitionType().asType();
                builder.put((Object)BindingKey.contribution(keyFactory.forSubcomponentBuilder(builderType)), name);
            }
        });
        return builder.build();
    }

    protected AbstractComponentWriter(AbstractComponentWriter parent, ClassName name, BindingGraph graph) {
        this(parent.types, parent.elements, parent.keyFactory, parent.compilerOptions, name, graph, parent.subcomponentNames, parent.optionalFactories, parent.bindingExpressions.forChildComponent(), parent.componentRequirementFields.forChildComponent());
    }

    protected final FieldSpec.Builder componentField(TypeName type, String name) {
        return FieldSpec.builder((TypeName)type, (String)this.componentFieldNames.getUniqueName(name), (Modifier[])new Modifier[0]);
    }

    @Override
    public void addInitialization(CodeBlock codeBlock) {
        this.initializations.add(codeBlock);
    }

    @Override
    public void addField(FieldSpec fieldSpec) {
        this.component.addField(fieldSpec);
    }

    @Override
    public void addMethod(MethodSpec methodSpec) {
        this.component.addMethod(methodSpec);
    }

    @Override
    public String getUniqueMethodName(String name) {
        return this.componentMethodNames.getUniqueName(name);
    }

    @Override
    public void addType(TypeSpec typeSpec) {
        this.component.addType(typeSpec);
    }

    @Override
    public String getSubcomponentName(ComponentDescriptor subcomponentDescriptor) {
        return (String)Preconditions.checkNotNull((Object)((String)this.subcomponentNames.get((Object)subcomponentDescriptor)));
    }

    @Override
    public CodeBlock getReferenceReleasingProviderManagerExpression(Scope scope) {
        return ((MemberSelect)this.referenceReleasingProviderManagerFields.get((Object)scope)).getExpressionFor(this.name);
    }

    final TypeSpec.Builder write() {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"ComponentWriter has already been generated.");
        this.decorateComponent();
        if (AbstractComponentWriter.hasBuilder(this.graph)) {
            this.addBuilder();
        }
        MoreElements.getLocalAndInheritedMethods(this.graph.componentDescriptor().componentDefinitionType(), this.types, this.elements).forEach(method -> this.componentMethodNames.claim(method.getSimpleName()));
        this.addFactoryMethods();
        this.addReferenceReleasingProviderManagerFields();
        this.createBindingExpressions();
        this.createComponentRequirementFields();
        this.implementInterfaceMethods();
        this.addSubcomponents();
        this.writeInitializeAndInterfaceMethods();
        this.writeMembersInjectionMethods();
        this.component.addMethod(this.constructor.build());
        if (this.graph.componentDescriptor().kind().isTopLevel()) {
            this.optionalFactories.addMembers(this.component);
        }
        this.done = true;
        return this.component;
    }

    protected abstract void decorateComponent();

    private static boolean hasBuilder(BindingGraph graph) {
        ComponentDescriptor component = graph.componentDescriptor();
        return component.kind().isTopLevel() || component.builderSpec().isPresent();
    }

    private void addBuilder() {
        this.addBuilderClass(this.builder.typeSpec());
        this.constructor.addParameter((TypeName)this.builderName(), "builder", new Modifier[0]);
    }

    protected abstract void addBuilderClass(TypeSpec var1);

    protected final ClassName builderName() {
        return this.builder.name();
    }

    protected abstract void addFactoryMethods();

    private void addReferenceReleasingProviderManagerFields() {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Scope scope : this.graph.scopesRequiringReleasableReferenceManagers()) {
            FieldSpec field = this.referenceReleasingProxyManagerField(scope);
            this.component.addField(field);
            fields.put((Object)scope, (Object)MemberSelect.localField(this.name, field.name));
        }
        this.referenceReleasingProviderManagerFields = fields.build();
    }

    protected abstract boolean requiresReleasableReferences(Scope var1);

    private FieldSpec referenceReleasingProxyManagerField(Scope scope) {
        return this.componentField((TypeName)TypeNames.REFERENCE_RELEASING_PROVIDER_MANAGER, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, scope.scopeAnnotationElement().getSimpleName() + "References")).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T($T.class)", new Object[]{TypeNames.REFERENCE_RELEASING_PROVIDER_MANAGER, scope.scopeAnnotationElement()}).addJavadoc("The manager that releases references for the {@link $T} scope.\n", new Object[]{scope.scopeAnnotationElement()}).build();
    }

    private void createBindingExpressions() {
        this.graph.resolvedBindings().values().forEach(this::createBindingExpression);
    }

    private void createBindingExpression(ResolvedBindings resolvedBindings) {
        Optional<BindingExpression> staticBindingExpression = this.bindingExpressionFactory.forStaticMethod(resolvedBindings);
        if (staticBindingExpression.isPresent()) {
            this.bindingExpressions.addBindingExpression(staticBindingExpression.get());
            return;
        }
        if (resolvedBindings.ownedBindings().isEmpty()) {
            return;
        }
        this.bindingExpressions.addBindingExpression(this.bindingExpressionFactory.forField(resolvedBindings));
    }

    private void createComponentRequirementFields() {
        this.builderFields.keySet().stream().map(this.componentRequirementFieldFactory::forBuilderField).forEach(this.componentRequirementFields::add);
    }

    private void implementInterfaceMethods() {
        HashSet interfaceMethodSignatures = Sets.newHashSet();
        DeclaredType componentType = MoreTypes.asDeclared(this.graph.componentType().asType());
        for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : this.graph.componentDescriptor().componentMethods()) {
            if (!componentMethod.dependencyRequest().isPresent()) continue;
            DependencyRequest interfaceRequest = componentMethod.dependencyRequest().get();
            ExecutableElement methodElement = componentMethod.methodElement();
            ExecutableType requestType = MoreTypes.asExecutable(this.types.asMemberOf(componentType, methodElement));
            MethodSignature signature = MethodSignature.fromExecutableType(methodElement.getSimpleName().toString(), requestType);
            if (!interfaceMethodSignatures.add(signature)) continue;
            MethodSpec.Builder interfaceMethod = MethodSpec.overriding((ExecutableElement)methodElement, (DeclaredType)componentType, (Types)this.types);
            List<? extends VariableElement> parameters = methodElement.getParameters();
            if (interfaceRequest.kind().equals((Object)DependencyRequest.Kind.MEMBERS_INJECTOR) && !parameters.isEmpty()) {
                ParameterSpec parameter = ParameterSpec.get((VariableElement)((VariableElement)Iterables.getOnlyElement(parameters)));
                MembersInjectionBinding binding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)interfaceRequest.bindingKey())).membersInjectionBinding().get();
                if (requestType.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                    if (!binding.injectionSites().isEmpty()) {
                        interfaceMethod.addStatement("$N($N)", new Object[]{this.getMembersInjectionMethod(binding.key()), parameter});
                    }
                } else if (binding.injectionSites().isEmpty()) {
                    interfaceMethod.addStatement("return $N", new Object[]{parameter});
                } else {
                    interfaceMethod.addStatement("return $N($N)", new Object[]{this.getMembersInjectionMethod(binding.key()), parameter});
                }
            } else {
                interfaceMethod.addStatement("return $L", new Object[]{this.bindingExpressions.getDependencyExpression(interfaceRequest, this.name).codeBlock()});
            }
            this.interfaceMethods.add(interfaceMethod.build());
        }
    }

    private void addSubcomponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            ComponentDescriptor.ComponentMethodDescriptor componentMethodDescriptor = (ComponentDescriptor.ComponentMethodDescriptor)this.graph.componentDescriptor().subcomponentsByFactoryMethod().inverse().get((Object)subgraph.componentDescriptor());
            SubcomponentWriter subcomponent = new SubcomponentWriter(this, Optional.ofNullable(componentMethodDescriptor), subgraph);
            this.component.addType(subcomponent.write().build());
        }
    }

    private void writeInitializeAndInterfaceMethods() {
        List partitions = Lists.partition(this.initializations, (int)100);
        UniqueNameSet methodNames = new UniqueNameSet();
        for (List partition : partitions) {
            String methodName = methodNames.getUniqueName("initialize");
            MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addCode(CodeBlocks.concat(partition));
            if (AbstractComponentWriter.hasBuilder(this.graph)) {
                initializeMethod.addParameter((TypeName)this.builderName(), "builder", new Modifier[]{Modifier.FINAL});
                this.constructor.addStatement("$L(builder)", new Object[]{methodName});
            } else {
                this.constructor.addStatement("$L()", new Object[]{methodName});
            }
            this.component.addMethod(initializeMethod.build());
        }
        this.component.addMethods(this.interfaceMethods);
    }

    private void writeMembersInjectionMethods() {
        this.component.addMethods(this.membersInjectionMethods.values());
    }

    @Override
    public MethodSpec getMembersInjectionMethod(Key key) {
        return Util.reentrantComputeIfAbsent(this.membersInjectionMethods, key, this::membersInjectionMethod);
    }

    private MethodSpec membersInjectionMethod(Key key) {
        Binding binding = ((ResolvedBindings)MoreObjects.firstNonNull((Object)((ResolvedBindings)this.graph.resolvedBindings().get((Object)BindingKey.membersInjection(key))), (Object)((ResolvedBindings)this.graph.resolvedBindings().get((Object)BindingKey.contribution(key))))).binding();
        TypeMirror keyType = binding.key().type();
        TypeMirror membersInjectedType = Accessibility.isTypeAccessibleFrom(keyType, this.name.packageName()) ? keyType : this.elements.getTypeElement("java.lang.Object").asType();
        TypeName membersInjectedTypeName = TypeName.get((TypeMirror)membersInjectedType);
        Name bindingTypeName = binding.bindingTypeElement().get().getSimpleName();
        String methodName = this.componentMethodNames.getUniqueName("inject" + bindingTypeName);
        ParameterSpec parameter = ParameterSpec.builder((TypeName)membersInjectedTypeName, (String)"instance", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(membersInjectedTypeName).addParameter(parameter);
        TypeElement canIgnoreReturnValue = this.elements.getTypeElement("com.google.errorprone.annotations.CanIgnoreReturnValue");
        if (canIgnoreReturnValue != null) {
            method.addAnnotation(ClassName.get((TypeElement)canIgnoreReturnValue));
        }
        CodeBlock instance = CodeBlock.of((String)"$N", (Object[])new Object[]{parameter});
        method.addCode(InjectionMethods.InjectionSiteMethod.invokeAll(AbstractComponentWriter.injectionSites(binding), this.name, instance, membersInjectedType, this.types, request -> this.bindingExpressions.getDependencyArgumentExpression((DependencyRequest)request, this.name).codeBlock()));
        method.addStatement("return $L", new Object[]{instance});
        return method.build();
    }

    static ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites(Binding binding) {
        if (binding instanceof ProvisionBinding) {
            return ((ProvisionBinding)binding).injectionSites();
        }
        if (binding instanceof MembersInjectionBinding) {
            return ((MembersInjectionBinding)binding).injectionSites();
        }
        throw new IllegalArgumentException(binding.key().toString());
    }

    @Override
    public CodeBlock decorateForScope(CodeBlock factoryCreate, Optional<Scope> maybeScope) {
        if (!maybeScope.isPresent()) {
            return factoryCreate;
        }
        Scope scope = maybeScope.get();
        if (this.requiresReleasableReferences(scope)) {
            return CodeBlock.of((String)"$T.create($L, $L)", (Object[])new Object[]{TypeNames.REFERENCE_RELEASING_PROVIDER, factoryCreate, this.getReferenceReleasingProviderManagerExpression(scope)});
        }
        return CodeBlock.of((String)"$T.provider($L)", (Object[])new Object[]{scope.equals(Scope.reusableScope(this.elements)) ? TypeNames.SINGLE_CHECK : TypeNames.DOUBLE_CHECK, factoryCreate});
    }
}

