/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AnnotationCreatorGenerator;
import dagger.internal.codegen.CodeBlocks;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;

class AnnotationExpression
extends SimpleAnnotationValueVisitor6<CodeBlock, AnnotationValue> {
    private final AnnotationMirror annotation;
    private final ClassName creatorClass;
    private static final SimpleTypeVisitor6<CodeBlock, CodeBlock> ARRAY_LITERAL_PREFIX = new SimpleTypeVisitor6<CodeBlock, CodeBlock>(){

        @Override
        public CodeBlock visitArray(ArrayType t, CodeBlock p) {
            return CodeBlock.of((String)"new $T[] $L", (Object[])new Object[]{RAW_TYPE_NAME.visit(t.getComponentType()), p});
        }

        @Override
        protected CodeBlock defaultAction(TypeMirror e, CodeBlock p) {
            return p;
        }
    };
    private static final SimpleTypeVisitor6<TypeName, Void> RAW_TYPE_NAME = new SimpleTypeVisitor6<TypeName, Void>(){

        @Override
        public TypeName visitDeclared(DeclaredType t, Void p) {
            return ClassName.get((TypeElement)MoreTypes.asTypeElement(t));
        }

        @Override
        protected TypeName defaultAction(TypeMirror e, Void p) {
            return TypeName.get((TypeMirror)e);
        }
    };

    AnnotationExpression(AnnotationMirror annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationCreatorGenerator.getAnnotationCreatorClassName(MoreTypes.asTypeElement(annotation.getAnnotationType()));
    }

    CodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private CodeBlock getAnnotationInstanceExpression(AnnotationMirror annotation) {
        return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{this.creatorClass, AnnotationCreatorGenerator.createMethodName(MoreElements.asType(annotation.getAnnotationType().asElement())), CodeBlocks.makeParametersCodeBlock(AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).entrySet().stream().map(entry -> this.getValueExpression(((ExecutableElement)entry.getKey()).getReturnType(), (AnnotationValue)entry.getValue())).collect(Collectors.toList()))});
    }

    CodeBlock getValueExpression(TypeMirror valueType, AnnotationValue value) {
        return (CodeBlock)ARRAY_LITERAL_PREFIX.visit(valueType, (CodeBlock)this.visit(value, value));
    }

    @Override
    public CodeBlock visitEnumConstant(VariableElement c, AnnotationValue p) {
        return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{c.getEnclosingElement(), c.getSimpleName()});
    }

    @Override
    public CodeBlock visitAnnotation(AnnotationMirror a, AnnotationValue p) {
        return this.getAnnotationInstanceExpression(a);
    }

    @Override
    public CodeBlock visitType(TypeMirror t, AnnotationValue p) {
        return CodeBlock.of((String)"$T.class", (Object[])new Object[]{t});
    }

    @Override
    public CodeBlock visitString(String s, AnnotationValue p) {
        return CodeBlock.of((String)"$S", (Object[])new Object[]{s});
    }

    @Override
    public CodeBlock visitByte(byte b, AnnotationValue p) {
        return CodeBlock.of((String)"(byte) $L", (Object[])new Object[]{b});
    }

    @Override
    public CodeBlock visitChar(char c, AnnotationValue p) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{p});
    }

    @Override
    public CodeBlock visitDouble(double d, AnnotationValue p) {
        return CodeBlock.of((String)"$LD", (Object[])new Object[]{d});
    }

    @Override
    public CodeBlock visitFloat(float f, AnnotationValue p) {
        return CodeBlock.of((String)"$LF", (Object[])new Object[]{Float.valueOf(f)});
    }

    @Override
    public CodeBlock visitLong(long i, AnnotationValue p) {
        return CodeBlock.of((String)"$LL", (Object[])new Object[]{i});
    }

    @Override
    public CodeBlock visitShort(short s, AnnotationValue p) {
        return CodeBlock.of((String)"(short) $L", (Object[])new Object[]{s});
    }

    @Override
    protected CodeBlock defaultAction(Object o, AnnotationValue p) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{o});
    }

    @Override
    public CodeBlock visitArray(List<? extends AnnotationValue> values, AnnotationValue p) {
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        for (AnnotationValue annotationValue : values) {
            codeBlocks.add((Object)((CodeBlock)this.visit(annotationValue, p)));
        }
        return CodeBlock.of((String)"{$L}", (Object[])new Object[]{CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)codeBlocks.build())});
    }
}

