/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.BoundInstanceBindingExpression;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentInstanceBindingExpression;
import dagger.internal.codegen.ComponentProvisionBindingExpression;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DelegateBindingExpression;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MapBindingExpression;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.OptionalBindingExpression;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.PrivateMethodBindingExpression;
import dagger.internal.codegen.ProviderOrProducerBindingExpression;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetBindingExpression;
import dagger.internal.codegen.SimpleMethodBindingExpression;
import dagger.internal.codegen.SubcomponentBuilderBindingExpression;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;

abstract class BindingExpression {
    private final ResolvedBindings resolvedBindings;

    BindingExpression(ResolvedBindings resolvedBindings) {
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
    }

    final ResolvedBindings resolvedBindings() {
        return this.resolvedBindings;
    }

    abstract Expression getDependencyExpression(DependencyRequest.Kind var1, ClassName var2);

    static final class Factory {
        private final CompilerOptions compilerOptions;
        private final ClassName componentName;
        private final UniqueNameSet componentFieldNames;
        private final ComponentBindingExpressions componentBindingExpressions;
        private final ComponentRequirementFields componentRequirementFields;
        private final GeneratedComponentModel generatedComponentModel;
        private final ImmutableMap<BindingKey, String> subcomponentNames;
        private final BindingGraph graph;
        private final DaggerTypes types;
        private final Elements elements;
        private final OptionalFactories optionalFactories;

        Factory(CompilerOptions compilerOptions, ClassName componentName, UniqueNameSet componentFieldNames, ComponentBindingExpressions componentBindingExpressions, ComponentRequirementFields componentRequirementFields, GeneratedComponentModel generatedComponentModel, ImmutableMap<BindingKey, String> subcomponentNames, BindingGraph graph, DaggerTypes types, Elements elements, OptionalFactories optionalFactories) {
            this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
            this.componentName = (ClassName)Preconditions.checkNotNull((Object)componentName);
            this.componentFieldNames = (UniqueNameSet)Preconditions.checkNotNull((Object)componentFieldNames);
            this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
            this.componentRequirementFields = (ComponentRequirementFields)Preconditions.checkNotNull((Object)componentRequirementFields);
            this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
            this.subcomponentNames = (ImmutableMap)Preconditions.checkNotNull(subcomponentNames);
            this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
            this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
            this.optionalFactories = (OptionalFactories)Preconditions.checkNotNull((Object)optionalFactories);
        }

        BindingExpression forField(ResolvedBindings resolvedBindings) {
            FieldSpec fieldSpec = this.generateFrameworkField(resolvedBindings, Optional.empty());
            MemberSelect memberSelect = MemberSelect.localField(this.componentName, fieldSpec.name);
            return this.create(resolvedBindings, Optional.of(fieldSpec), memberSelect);
        }

        Optional<BindingExpression> forStaticMethod(ResolvedBindings resolvedBindings) {
            return MemberSelect.staticMemberSelect(resolvedBindings).map(memberSelect -> this.create(resolvedBindings, Optional.empty(), (MemberSelect)memberSelect));
        }

        private FieldSpec generateFrameworkField(ResolvedBindings resolvedBindings, Optional<ClassName> frameworkClass) {
            boolean useRawType = this.useRawType(resolvedBindings);
            FrameworkField contributionBindingField = FrameworkField.forResolvedBindings(resolvedBindings, frameworkClass);
            FieldSpec.Builder contributionField = FieldSpec.builder((TypeName)(useRawType ? contributionBindingField.type().rawType : contributionBindingField.type()), (String)this.componentFieldNames.getUniqueName(contributionBindingField.name()), (Modifier[])new Modifier[0]);
            contributionField.addModifiers(new Modifier[]{Modifier.PRIVATE});
            if (useRawType) {
                contributionField.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
            }
            return contributionField.build();
        }

        private boolean useRawType(ResolvedBindings resolvedBindings) {
            Optional<String> bindingPackage = resolvedBindings.bindingPackage();
            return bindingPackage.isPresent() && !bindingPackage.get().equals(this.componentName.packageName());
        }

        private BindingExpression create(ResolvedBindings resolvedBindings, Optional<FieldSpec> fieldSpec, MemberSelect memberSelect) {
            FrameworkFieldInitializer frameworkFieldInitializer = new FrameworkFieldInitializer(this.generatedComponentModel, this.componentBindingExpressions, this.componentRequirementFields, resolvedBindings, this.compilerOptions, this.graph, this.optionalFactories, this.componentName);
            FrameworkInstanceBindingExpression frameworkInstanceBindingExpression = FrameworkInstanceBindingExpression.create(resolvedBindings, fieldSpec, this.generatedComponentModel, memberSelect, frameworkFieldInitializer, this.types, this.elements);
            if (!resolvedBindings.bindingType().equals((Object)BindingType.PROVISION)) {
                return frameworkInstanceBindingExpression;
            }
            ProviderOrProducerBindingExpression bindingExpression = new ProviderOrProducerBindingExpression(frameworkInstanceBindingExpression, frameworkInstanceBindingExpression.producerFromProvider(this.generateFrameworkField(resolvedBindings, Optional.of(TypeNames.PRODUCER)), this.componentName));
            ProvisionBinding provisionBinding = (ProvisionBinding)resolvedBindings.contributionBinding();
            switch (provisionBinding.bindingKind()) {
                case COMPONENT: {
                    return new ComponentInstanceBindingExpression(bindingExpression, provisionBinding, this.componentName, this.types);
                }
                case COMPONENT_DEPENDENCY: {
                    return new BoundInstanceBindingExpression(bindingExpression, ComponentRequirement.forDependency(provisionBinding.key().type()), this.componentRequirementFields, this.types);
                }
                case COMPONENT_PROVISION: {
                    return new ComponentProvisionBindingExpression(bindingExpression, provisionBinding, this.graph, this.componentRequirementFields, this.compilerOptions, this.types);
                }
                case SUBCOMPONENT_BUILDER: {
                    return new SubcomponentBuilderBindingExpression(bindingExpression, provisionBinding, (String)this.subcomponentNames.get((Object)resolvedBindings.bindingKey()), this.types);
                }
                case SYNTHETIC_MULTIBOUND_SET: {
                    return new SetBindingExpression(provisionBinding, this.graph, this.componentBindingExpressions, bindingExpression, this.types, this.elements);
                }
                case SYNTHETIC_MULTIBOUND_MAP: {
                    return new MapBindingExpression(provisionBinding, this.graph, this.componentBindingExpressions, bindingExpression, this.types, this.elements);
                }
                case SYNTHETIC_OPTIONAL_BINDING: {
                    return new OptionalBindingExpression(provisionBinding, bindingExpression, this.componentBindingExpressions, this.types);
                }
                case SYNTHETIC_DELEGATE_BINDING: {
                    return DelegateBindingExpression.create(this.graph, bindingExpression, this.componentBindingExpressions, this.types, this.elements);
                }
                case BUILDER_BINDING: {
                    return new BoundInstanceBindingExpression(bindingExpression, ComponentRequirement.forBinding(provisionBinding), this.componentRequirementFields, this.types);
                }
                case INJECTION: 
                case PROVISION: {
                    if (provisionBinding.scope().isPresent() || !provisionBinding.bindingElement().isPresent()) break;
                    SimpleMethodBindingExpression simpleMethodBindingExpression = new SimpleMethodBindingExpression(this.compilerOptions, provisionBinding, bindingExpression, this.componentBindingExpressions, this.generatedComponentModel, this.componentRequirementFields, this.types, this.elements);
                    return this.compilerOptions.experimentalAndroidMode() ? new PrivateMethodBindingExpression(resolvedBindings, this.componentName, this.generatedComponentModel, simpleMethodBindingExpression, this.types, this.elements) : simpleMethodBindingExpression;
                }
            }
            return bindingExpression;
        }
    }
}

