/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import dagger.BindsInstance;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class BindsInstanceProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private static final ImmutableSet<Class<? extends Annotation>> COMPONENT_ANNOTATIONS = Stream.of(ComponentDescriptor.Kind.values()).map(ComponentDescriptor.Kind::annotationType).collect(Util.toImmutableSet());
    private static final ImmutableSet<Class<? extends Annotation>> MODULE_ANNOTATIONS = Stream.of(ModuleDescriptor.Kind.values()).map(ModuleDescriptor.Kind::moduleAnnotation).collect(Util.toImmutableSet());
    private final Messager messager;

    BindsInstanceProcessingStep(Messager messager) {
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(BindsInstance.class);
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (Element element : elementsByAnnotation.get(BindsInstance.class)) {
            ExecutableElement method = MoreElements.asExecutable(element);
            ValidationReport.Builder<ExecutableElement> report = ValidationReport.about(method);
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                report.addError("@BindsInstance methods must be abstract");
            }
            if (method.getParameters().size() != 1) {
                report.addError("@BindsInstance methods should have exactly one parameter for the bound type");
            } else {
                VariableElement parameter = (VariableElement)Iterables.getOnlyElement(method.getParameters());
                if (FrameworkTypes.isFrameworkType(parameter.asType())) {
                    report.addError("@BindsInstance parameters may not be framework types", parameter);
                }
            }
            TypeElement enclosingType = MoreElements.asType(method.getEnclosingElement());
            if (DaggerElements.isAnyAnnotationPresent(enclosingType, MODULE_ANNOTATIONS)) {
                report.addError(String.format("@BindsInstance methods should not be included in @%ss. Did you mean @Binds?", MoreAnnotationMirrors.simpleName(ConfigurationAnnotations.getModuleAnnotation(enclosingType).get())));
            }
            if (DaggerElements.isAnyAnnotationPresent(enclosingType, COMPONENT_ANNOTATIONS)) {
                AnnotationMirror componentAnnotation = ConfigurationAnnotations.getComponentOrSubcomponentAnnotation(enclosingType).get();
                report.addError(String.format("@BindsInstance methods should not be included in @%1$ss. Did you mean to put it in a @%1$s.Builder?", MoreAnnotationMirrors.simpleName(componentAnnotation)));
            }
            report.build().printMessagesTo(this.messager);
        }
        return ImmutableSet.of();
    }
}

