/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkDependency;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class ComponentBindingExpressions {
    private final ImmutableList<Map<BindingKey, BindingExpression>> bindingExpressionsMaps;
    private final Types types;

    private ComponentBindingExpressions(ImmutableList<Map<BindingKey, BindingExpression>> bindingExpressionsMaps, Types types) {
        this.bindingExpressionsMaps = bindingExpressionsMaps;
        this.types = types;
    }

    ComponentBindingExpressions(Types types) {
        this((ImmutableList<Map<BindingKey, BindingExpression>>)ImmutableList.of(ComponentBindingExpressions.newBindingExpressionMap()), types);
    }

    Expression getDependencyExpression(BindingKey bindingKey, DependencyRequest.Kind requestKind, ClassName requestingClass) {
        return this.getBindingExpression(bindingKey).getDependencyExpression(requestKind, requestingClass);
    }

    Expression getDependencyExpression(DependencyRequest request, ClassName requestingClass) {
        return this.getDependencyExpression(request.bindingKey(), request.kind(), requestingClass);
    }

    Expression getDependencyExpression(FrameworkDependency frameworkDependency, ClassName requestingClass) {
        return this.getDependencyExpression(frameworkDependency.bindingKey(), frameworkDependency.dependencyRequestKind(), requestingClass);
    }

    Expression getDependencyArgumentExpression(DependencyRequest dependencyRequest, ClassName requestingClass) {
        TypeMirror dependencyType = dependencyRequest.key().type();
        Expression dependencyExpression = this.getDependencyExpression(dependencyRequest, requestingClass);
        if (!Accessibility.isTypeAccessibleFrom(dependencyType, requestingClass.packageName()) && Accessibility.isRawTypeAccessible(dependencyType, requestingClass.packageName())) {
            return dependencyExpression.castTo(this.types.erasure(dependencyType));
        }
        return dependencyExpression;
    }

    private BindingExpression getBindingExpression(BindingKey bindingKey) {
        for (Map bindingExpressionsMap : this.bindingExpressionsMaps) {
            BindingExpression expression = (BindingExpression)bindingExpressionsMap.get(bindingKey);
            if (expression == null) continue;
            return expression;
        }
        throw new IllegalStateException("no binding expression found for " + bindingKey);
    }

    void addBindingExpression(BindingExpression bindingExpression) {
        ((Map)this.bindingExpressionsMaps.get(0)).put(bindingExpression.resolvedBindings().bindingKey(), bindingExpression);
    }

    ComponentBindingExpressions forChildComponent() {
        return new ComponentBindingExpressions((ImmutableList<Map<BindingKey, BindingExpression>>)FluentIterable.of(ComponentBindingExpressions.newBindingExpressionMap(), (Object[])new Map[0]).append(this.bindingExpressionsMaps).toList(), this.types);
    }

    private static Map<BindingKey, BindingExpression> newBindingExpressionMap() {
        return new HashMap<BindingKey, BindingExpression>();
    }
}

