/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentWriter;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.SourceFileGenerator;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class ComponentGenerator
extends SourceFileGenerator<BindingGraph> {
    private final DaggerTypes types;
    private final Elements elements;
    private final Key.Factory keyFactory;
    private final CompilerOptions compilerOptions;

    ComponentGenerator(Filer filer, Elements elements, DaggerTypes types, Key.Factory keyFactory, CompilerOptions compilerOptions) {
        super(filer, elements);
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    ClassName nameGeneratedType(BindingGraph input) {
        ClassName componentDefinitionClassName = ClassName.get((TypeElement)input.componentType());
        String componentName = "Dagger" + Joiner.on((char)'_').join((Iterable)componentDefinitionClassName.simpleNames());
        return componentDefinitionClassName.topLevelClassName().peerClass(componentName);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(BindingGraph input) {
        return Optional.of(input.componentType());
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName componentName, BindingGraph input) {
        return Optional.of(new ComponentWriter(this.types, this.elements, this.keyFactory, this.compilerOptions, componentName, input).write());
    }
}

