/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.UniqueNameSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

abstract class ComponentRequirementField {
    private final ComponentRequirement componentRequirement;

    private ComponentRequirementField(ComponentRequirement componentRequirement) {
        this.componentRequirement = (ComponentRequirement)Preconditions.checkNotNull((Object)componentRequirement);
    }

    final ComponentRequirement componentRequirement() {
        return this.componentRequirement;
    }

    abstract CodeBlock getExpression(ClassName var1);

    abstract CodeBlock getExpressionDuringInitialization(ClassName var1);

    static ComponentRequirementField componentField(ComponentRequirement componentRequirement, FieldSpec componentField, ClassName owningComponent) {
        return new ComponentField(componentRequirement, componentField, owningComponent);
    }

    static final class Factory {
        private final GeneratedComponentModel generatedComponentModel;
        private final UniqueNameSet componentFieldNames;
        private final ClassName owningComponent;
        private final ImmutableMap<ComponentRequirement, FieldSpec> builderFields;

        Factory(GeneratedComponentModel generatedComponentModel, UniqueNameSet componentFieldNames, ClassName owningComponent, ImmutableMap<ComponentRequirement, FieldSpec> builderFields) {
            this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
            this.componentFieldNames = (UniqueNameSet)Preconditions.checkNotNull((Object)componentFieldNames);
            this.owningComponent = (ClassName)Preconditions.checkNotNull((Object)owningComponent);
            this.builderFields = (ImmutableMap)Preconditions.checkNotNull(builderFields);
        }

        ComponentRequirementField forBuilderField(ComponentRequirement componentRequirement) {
            return new BuilderField(componentRequirement, this.generatedComponentModel, this.componentFieldNames, this.owningComponent, (FieldSpec)this.builderFields.get((Object)componentRequirement));
        }
    }

    private static final class ComponentField
    extends ComponentRequirementField {
        private final MemberSelect memberSelect;

        private ComponentField(ComponentRequirement componentRequirement, FieldSpec componentField, ClassName owningComponent) {
            super(componentRequirement);
            this.memberSelect = MemberSelect.localField(owningComponent, componentField.name);
        }

        @Override
        CodeBlock getExpression(ClassName requestingClass) {
            return this.memberSelect.getExpressionFor(requestingClass);
        }

        @Override
        CodeBlock getExpressionDuringInitialization(ClassName requestingClass) {
            return this.getExpression(requestingClass);
        }
    }

    private static final class BuilderField
    extends ComponentRequirementField {
        private final GeneratedComponentModel generatedComponentModel;
        private final UniqueNameSet componentFieldNames;
        private final ClassName owningComponent;
        private final FieldSpec builderField;
        private MemberSelect field;

        private BuilderField(ComponentRequirement componentRequirement, GeneratedComponentModel generatedComponentModel, UniqueNameSet componentFieldNames, ClassName owningComponent, FieldSpec builderField) {
            super(componentRequirement);
            this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
            this.componentFieldNames = (UniqueNameSet)Preconditions.checkNotNull((Object)componentFieldNames);
            this.owningComponent = (ClassName)Preconditions.checkNotNull((Object)owningComponent);
            this.builderField = (FieldSpec)Preconditions.checkNotNull((Object)builderField);
        }

        @Override
        CodeBlock getExpression(ClassName requestingClass) {
            return this.getField().getExpressionFor(requestingClass);
        }

        @Override
        CodeBlock getExpressionDuringInitialization(ClassName requestingClass) {
            if (this.owningComponent.equals((Object)requestingClass)) {
                return CodeBlock.of((String)"builder.$N", (Object[])new Object[]{this.builderField});
            }
            return this.getExpression(requestingClass);
        }

        private MemberSelect getField() {
            if (this.field == null) {
                String fieldName = this.componentFieldNames.getUniqueName(this.componentRequirement().variableName());
                FieldSpec componentField = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.componentRequirement().type()), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
                this.generatedComponentModel.addField(componentField);
                this.generatedComponentModel.addInitialization(CodeBlock.of((String)"this.$N = builder.$N;", (Object[])new Object[]{componentField, this.builderField}));
                this.field = MemberSelect.localField(this.owningComponent, fieldName);
            }
            return this.field;
        }
    }
}

