/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Reusable;
import dagger.internal.codegen.AutoValue_ComponentValidator_ComponentValidationReport;
import dagger.internal.codegen.BuilderValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class ComponentValidator {
    private final Elements elements;
    private final Types types;
    private final ModuleValidator moduleValidator;
    private final ComponentValidator subcomponentValidator;
    private final BuilderValidator subcomponentBuilderValidator;

    private ComponentValidator(Elements elements, Types types, ModuleValidator moduleValidator, BuilderValidator subcomponentBuilderValidator) {
        this.elements = elements;
        this.types = types;
        this.moduleValidator = moduleValidator;
        this.subcomponentValidator = this;
        this.subcomponentBuilderValidator = subcomponentBuilderValidator;
    }

    private ComponentValidator(Elements elements, Types types, ModuleValidator moduleValidator, ComponentValidator subcomponentValidator, BuilderValidator subcomponentBuilderValidator) {
        this.elements = elements;
        this.types = types;
        this.moduleValidator = moduleValidator;
        this.subcomponentValidator = subcomponentValidator;
        this.subcomponentBuilderValidator = subcomponentBuilderValidator;
    }

    static ComponentValidator createForComponent(Elements elements, Types types, ModuleValidator moduleValidator, ComponentValidator subcomponentValidator, BuilderValidator subcomponentBuilderValidator) {
        return new ComponentValidator(elements, types, moduleValidator, subcomponentValidator, subcomponentBuilderValidator);
    }

    static ComponentValidator createForSubcomponent(Elements elements, Types types, ModuleValidator moduleValidator, BuilderValidator subcomponentBuilderValidator) {
        return new ComponentValidator(elements, types, moduleValidator, subcomponentBuilderValidator);
    }

    public ComponentValidationReport validate(TypeElement subject, Set<? extends Element> validatedSubcomponents, Set<? extends Element> validatedSubcomponentBuilders) {
        Optional<AnnotationMirror> reusableAnnotation;
        ImmutableList<DeclaredType> builders;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(subject);
        ComponentDescriptor.Kind componentKind = ComponentDescriptor.Kind.forAnnotatedElement(subject).get();
        if (!(subject.getKind().equals((Object)ElementKind.INTERFACE) || subject.getKind().equals((Object)ElementKind.CLASS) && subject.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            builder.addError(String.format("@%s may only be applied to an interface or abstract class", componentKind.annotationType().getSimpleName()), subject);
        }
        if ((builders = ConfigurationAnnotations.enclosedBuilders(subject, componentKind.builderAnnotationType())).size() > 1) {
            builder.addError(String.format(ErrorMessages.builderMsgsFor(componentKind).moreThanOne(), builders), subject);
        }
        if ((reusableAnnotation = DaggerElements.getAnnotationMirror(subject, Reusable.class)).isPresent()) {
            builder.addError("@Reusable cannot be applied to components or subcomponents.", subject, reusableAnnotation.get());
        }
        DeclaredType subjectType = MoreTypes.asDeclared(subject.asType());
        LinkedHashMultimap referencedSubcomponents = LinkedHashMultimap.create();
        MoreElements.getLocalAndInheritedMethods(subject, this.types, this.elements).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).forEachOrdered(arg_0 -> this.lambda$validate$1(subjectType, componentKind, (SetMultimap)referencedSubcomponents, builder, validatedSubcomponentBuilders, arg_0));
        Maps.filterValues((Map)referencedSubcomponents.asMap(), methods -> methods.size() > 1).forEach((subcomponent, methods) -> builder.addError(String.format(ErrorMessages.SubcomponentBuilderMessages.INSTANCE.moreThanOneRefToSubcomponent(), subcomponent, methods), subject));
        AnnotationMirror componentMirror = DaggerElements.getAnnotationMirror(subject, componentKind.annotationType()).get();
        if (componentKind.isTopLevel()) {
            ConfigurationAnnotations.validateComponentDependencies(builder, ConfigurationAnnotations.getComponentDependencies(componentMirror));
        }
        builder.addSubreport(this.moduleValidator.validateReferencedModules(subject, componentMirror, componentKind.moduleKinds()));
        ImmutableSet.Builder allSubcomponents = ImmutableSet.builder().addAll((Iterable)referencedSubcomponents.keySet());
        for (Element subcomponent2 : Sets.difference((Set)referencedSubcomponents.keySet(), validatedSubcomponents)) {
            ComponentValidationReport subreport = this.subcomponentValidator.validate(MoreElements.asType(subcomponent2), validatedSubcomponents, validatedSubcomponentBuilders);
            builder.addItems((Iterable<ValidationReport.Item>)subreport.report().items());
            allSubcomponents.addAll(subreport.referencedSubcomponents());
        }
        return new AutoValue_ComponentValidator_ComponentValidationReport((Set<Element>)allSubcomponents.build(), builder.build());
    }

    private void validateSubcomponentMethod(ValidationReport.Builder<TypeElement> builder, final ComponentDescriptor.Kind subcomponentKind, ExecutableElement method, List<? extends VariableElement> parameters, List<? extends TypeMirror> parameterTypes, TypeMirror returnType, Optional<AnnotationMirror> subcomponentAnnotation) {
        ImmutableSet<TypeElement> moduleTypes = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentModules(subcomponentAnnotation.get()));
        ImmutableSet<TypeElement> transitiveModules = ConfigurationAnnotations.getTransitiveModules(this.types, this.elements, moduleTypes);
        HashSet variableTypes = Sets.newHashSet();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameterTypes.get(i);
            Optional<TypeElement> moduleType = parameterType.accept(new SimpleTypeVisitor6<Optional<TypeElement>, Void>(){

                @Override
                protected Optional<TypeElement> defaultAction(TypeMirror e, Void p) {
                    return Optional.empty();
                }

                @Override
                public Optional<TypeElement> visitDeclared(DeclaredType t, Void p) {
                    for (ModuleDescriptor.Kind moduleKind : subcomponentKind.moduleKinds()) {
                        if (!MoreElements.isAnnotationPresent(t.asElement(), moduleKind.moduleAnnotation())) continue;
                        return Optional.of(MoreTypes.asTypeElement(t));
                    }
                    return Optional.empty();
                }
            }, null);
            if (moduleType.isPresent()) {
                if (variableTypes.contains(moduleType.get())) {
                    builder.addError(String.format("A module may only occur once an an argument in a Subcomponent factory method, but %s was already passed.", moduleType.get().getQualifiedName()), parameter);
                }
                if (!transitiveModules.contains((Object)moduleType.get())) {
                    builder.addError(String.format("%s is present as an argument to the %s factory method, but is not one of the modules used to implement the subcomponent.", moduleType.get().getQualifiedName(), MoreTypes.asTypeElement(returnType).getQualifiedName()), method);
                }
                variableTypes.add(moduleType.get());
                continue;
            }
            builder.addError(String.format("Subcomponent factory methods may only accept modules, but %s is not.", parameterType), parameter);
        }
    }

    private void validateSubcomponentBuilderMethod(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, List<? extends VariableElement> parameters, TypeMirror returnType, Set<? extends Element> validatedSubcomponentBuilders) {
        TypeElement builderElement;
        if (!parameters.isEmpty()) {
            builder.addError(ErrorMessages.SubcomponentBuilderMessages.INSTANCE.builderMethodRequiresNoArgs(), method);
        }
        if (!validatedSubcomponentBuilders.contains(builderElement = MoreTypes.asTypeElement(returnType))) {
            builder.addItems((Iterable<ValidationReport.Item>)this.subcomponentBuilderValidator.validate(builderElement).items());
        }
    }

    private static Optional<AnnotationMirror> checkForAnnotations(TypeMirror type, final Set<? extends Class<? extends Annotation>> annotations) {
        return type.accept(new SimpleTypeVisitor6<Optional<AnnotationMirror>, Void>(Optional.empty()){

            @Override
            public Optional<AnnotationMirror> visitDeclared(DeclaredType t, Void p) {
                return DaggerElements.getAnyAnnotation(t.asElement(), annotations);
            }
        }, null);
    }

    private /* synthetic */ void lambda$validate$1(DeclaredType subjectType, ComponentDescriptor.Kind componentKind, SetMultimap referencedSubcomponents, ValidationReport.Builder builder, Set validatedSubcomponentBuilders, ExecutableElement method) {
        ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(subjectType, method));
        List<? extends TypeMirror> parameterTypes = resolvedMethod.getParameterTypes();
        List<? extends VariableElement> parameters = method.getParameters();
        TypeMirror returnType = resolvedMethod.getReturnType();
        Optional<AnnotationMirror> subcomponentAnnotation = ComponentValidator.checkForAnnotations(returnType, (Set<? extends Class<? extends Annotation>>)FluentIterable.from(componentKind.subcomponentKinds()).transform(ComponentDescriptor.Kind::annotationType).toSet());
        Optional<AnnotationMirror> subcomponentBuilderAnnotation = ComponentValidator.checkForAnnotations(returnType, (Set<? extends Class<? extends Annotation>>)FluentIterable.from(componentKind.subcomponentKinds()).transform(ComponentDescriptor.Kind::builderAnnotationType).toSet());
        if (subcomponentAnnotation.isPresent()) {
            referencedSubcomponents.put((Object)MoreTypes.asElement(returnType), (Object)method);
            this.validateSubcomponentMethod(builder, ComponentDescriptor.Kind.forAnnotatedElement(MoreTypes.asTypeElement(returnType)).get(), method, parameters, parameterTypes, returnType, subcomponentAnnotation);
        } else if (subcomponentBuilderAnnotation.isPresent()) {
            referencedSubcomponents.put((Object)MoreTypes.asElement(returnType).getEnclosingElement(), (Object)method);
            this.validateSubcomponentBuilderMethod(builder, method, parameters, returnType, validatedSubcomponentBuilders);
        } else {
            switch (parameters.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    TypeMirror onlyParameter = (TypeMirror)Iterables.getOnlyElement(parameterTypes);
                    if (returnType.getKind().equals((Object)TypeKind.VOID) || this.types.isSameType(returnType, onlyParameter)) break;
                    builder.addError("Members injection methods may only return the injected type or void.", method);
                    break;
                }
                default: {
                    builder.addError("This method isn't a valid provision method, members injection method or subcomponent factory method. Dagger cannot implement this method", method);
                }
            }
        }
    }

    static abstract class ComponentValidationReport {
        ComponentValidationReport() {
        }

        abstract Set<Element> referencedSubcomponents();

        abstract ValidationReport<TypeElement> report();
    }
}

