/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.GwtCompatibility;
import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.InjectionMethods;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class FactoryGenerator
extends SourceFileGenerator<ProvisionBinding> {
    private final Types types;
    private final CompilerOptions compilerOptions;
    private final InjectValidator injectValidator;

    FactoryGenerator(Filer filer, Elements elements, Types types, CompilerOptions compilerOptions, InjectValidator injectValidator) {
        super(filer, elements);
        this.types = types;
        this.compilerOptions = compilerOptions;
        this.injectValidator = injectValidator;
    }

    @Override
    ClassName nameGeneratedType(ProvisionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProvisionBinding binding) {
        return binding.bindingElement();
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ProvisionBinding binding) {
        Optional<Object> createMethod;
        boolean factoryHasTypeParameters;
        com.google.common.base.Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        com.google.common.base.Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        if (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) && !this.injectValidator.isValidType(binding.contributedType())) {
            return Optional.empty();
        }
        TypeName providedTypeName = TypeName.get((TypeMirror)binding.contributedType());
        ParameterizedTypeName factoryTypeName = TypeNames.factoryOf(providedTypeName);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.FINAL});
        boolean bl = factoryHasTypeParameters = (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) || binding.requiresModuleInstance()) && !typeParameters.isEmpty();
        if (factoryHasTypeParameters) {
            factoryBuilder.addTypeVariables(typeParameters);
        }
        Optional<Object> constructorBuilder = Optional.empty();
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        ImmutableMap.Builder fieldsBuilder = ImmutableMap.builder();
        switch (binding.factoryCreationStrategy()) {
            case SINGLETON_INSTANCE: {
                FieldSpec.Builder instanceFieldBuilder = FieldSpec.builder((TypeName)generatedTypeName, (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{generatedTypeName});
                if (factoryHasTypeParameters) {
                    instanceFieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
                }
                factoryBuilder.addField(instanceFieldBuilder.build());
                break;
            }
            case CLASS_CONSTRUCTOR: {
                constructorBuilder = Optional.of(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}));
                if (binding.requiresModuleInstance()) {
                    this.addConstructorParameterAndTypeField(TypeName.get((TypeMirror)binding.bindingTypeElement().get().asType()), "module", factoryBuilder, (MethodSpec.Builder)constructorBuilder.get());
                }
                for (Map.Entry entry : SourceFiles.generateBindingFieldsForDependencies(binding).entrySet()) {
                    BindingKey bindingKey = (BindingKey)entry.getKey();
                    FrameworkField bindingField = (FrameworkField)entry.getValue();
                    FieldSpec field = this.addConstructorParameterAndTypeField((TypeName)bindingField.type(), uniqueFieldNames.getUniqueName(bindingField.name()), factoryBuilder, (MethodSpec.Builder)constructorBuilder.get());
                    fieldsBuilder.put((Object)bindingKey, (Object)field);
                }
                break;
            }
            case DELEGATE: {
                return Optional.empty();
            }
            default: {
                throw new AssertionError();
            }
        }
        ImmutableMap fields = fieldsBuilder.build();
        factoryBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)factoryTypeName);
        switch (binding.bindingKind()) {
            case INJECTION: 
            case PROVISION: {
                MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)factoryTypeName);
                if (factoryHasTypeParameters) {
                    createMethodBuilder.addTypeVariables(typeParameters);
                }
                ImmutableList params = constructorBuilder.isPresent() ? ((MethodSpec.Builder)constructorBuilder.get()).build().parameters : ImmutableList.of();
                createMethodBuilder.addParameters((Iterable)params);
                switch (binding.factoryCreationStrategy()) {
                    case SINGLETON_INSTANCE: {
                        if (factoryHasTypeParameters) {
                            createMethodBuilder.addStatement("return ($T) INSTANCE", new Object[]{TypeNames.FACTORY});
                            createMethodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, AnnotationSpecs.Suppression.UNCHECKED));
                            break;
                        }
                        createMethodBuilder.addStatement("return INSTANCE", new Object[0]);
                        break;
                    }
                    case CLASS_CONSTRUCTOR: {
                        createMethodBuilder.addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(Lists.transform((List)params, input -> CodeBlock.of((String)"$N", (Object[])new Object[]{input})))});
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                createMethod = Optional.of(createMethodBuilder.build());
                break;
            }
            default: {
                createMethod = Optional.empty();
            }
        }
        if (constructorBuilder.isPresent()) {
            factoryBuilder.addMethod(((MethodSpec.Builder)constructorBuilder.get()).build());
        }
        CodeBlock parametersCodeBlock = CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)SourceFiles.frameworkFieldUsages(binding.provisionDependencies(), (ImmutableMap<BindingKey, FieldSpec>)fields).values());
        MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder((String)"get").returns(providedTypeName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (binding.bindingKind().equals((Object)ContributionBinding.Kind.PROVISION)) {
            binding.nullableType().ifPresent(nullableType -> CodeBlocks.addAnnotation(getMethodBuilder, nullableType));
            CodeBlock methodCall = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{binding.requiresModuleInstance() ? "module" : CodeBlock.of((String)"$T", (Object[])new Object[]{ClassName.get((TypeElement)binding.bindingTypeElement().get())}), binding.bindingElement().get().getSimpleName(), parametersCodeBlock});
            getMethodBuilder.addStatement("return $L", new Object[]{binding.shouldCheckForNull(this.compilerOptions) ? FactoryGenerator.checkNotNullProvidesMethod(methodCall) : methodCall});
        } else if (!binding.injectionSites().isEmpty()) {
            CodeBlock instance = CodeBlock.of((String)"instance", (Object[])new Object[0]);
            getMethodBuilder.addStatement("$1T $2L = new $1T($3L)", new Object[]{providedTypeName, instance, parametersCodeBlock}).addCode(InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), generatedTypeName, instance, binding.key().type(), this.types, arg_0 -> SourceFiles.frameworkFieldUsages(binding.dependencies(), (ImmutableMap<BindingKey, FieldSpec>)fields).get(arg_0))).addStatement("return $L", new Object[]{instance});
        } else {
            getMethodBuilder.addStatement("return new $T($L)", new Object[]{providedTypeName, parametersCodeBlock});
        }
        factoryBuilder.addMethod(getMethodBuilder.build());
        if (createMethod.isPresent()) {
            factoryBuilder.addMethod((MethodSpec)createMethod.get());
        }
        InjectionMethods.ProvisionMethod.create(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addMethod(arg_0));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addAnnotation(arg_0));
        MapKeys.mapKeyFactoryMethod(binding, this.types).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addMethod(arg_0));
        return Optional.of(factoryBuilder);
    }

    static CodeBlock checkNotNullProvidesMethod(CodeBlock providesMethodInvocation) {
        return CodeBlock.of((String)"$T.checkNotNull($L, $S)", (Object[])new Object[]{Preconditions.class, providesMethodInvocation, "Cannot return null from a non-@Nullable @Provides method"});
    }

    @CanIgnoreReturnValue
    private FieldSpec addConstructorParameterAndTypeField(TypeName typeName, String variableName, TypeSpec.Builder factoryBuilder, MethodSpec.Builder constructorBuilder) {
        FieldSpec field = FieldSpec.builder((TypeName)typeName, (String)variableName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        factoryBuilder.addField(field);
        ParameterSpec parameter = ParameterSpec.builder((TypeName)typeName, (String)variableName, (Modifier[])new Modifier[0]).build();
        constructorBuilder.addParameter(parameter);
        constructorBuilder.addCode("this.$N = $N;", new Object[]{field, parameter});
        return field;
    }
}

