/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.InstanceFactory;
import dagger.internal.codegen.AnnotationExpression;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentProvisionBindingExpression;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.Util;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.releasablereferences.ReleasableReferenceManager;
import dagger.releasablereferences.TypedReleasableReferenceManager;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class FrameworkFieldInitializer {
    private final GeneratedComponentModel generatedComponentModel;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final ComponentRequirementFields componentRequirementFields;
    private final ResolvedBindings resolvedBindings;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final boolean isProducerFromProvider;
    private final OptionalFactories optionalFactories;
    private final ClassName componentName;

    FrameworkFieldInitializer(GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, ComponentRequirementFields componentRequirementFields, ResolvedBindings resolvedBindings, CompilerOptions compilerOptions, BindingGraph graph, OptionalFactories optionalFactories, ClassName componentName) {
        this(generatedComponentModel, componentBindingExpressions, componentRequirementFields, resolvedBindings, compilerOptions, graph, false, optionalFactories, componentName);
    }

    private FrameworkFieldInitializer(GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, ComponentRequirementFields componentRequirementFields, ResolvedBindings resolvedBindings, CompilerOptions compilerOptions, BindingGraph graph, boolean isProducerFromProvider, OptionalFactories optionalFactories, ClassName componentName) {
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.componentRequirementFields = (ComponentRequirementFields)Preconditions.checkNotNull((Object)componentRequirementFields);
        this.resolvedBindings = (ResolvedBindings)Preconditions.checkNotNull((Object)resolvedBindings);
        this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
        this.optionalFactories = (OptionalFactories)Preconditions.checkNotNull((Object)optionalFactories);
        this.componentName = (ClassName)Preconditions.checkNotNull((Object)componentName);
        this.isProducerFromProvider = isProducerFromProvider;
    }

    CodeBlock getFieldInitialization() {
        if (this.isProducerFromProvider) {
            return FrameworkType.PROVIDER.to(DependencyRequest.Kind.PRODUCER, this.componentBindingExpressions.getDependencyExpression(FrameworkDependency.create(this.resolvedBindings.bindingKey(), BindingType.PROVISION), this.componentName).codeBlock());
        }
        switch (this.resolvedBindings.bindingKey().kind()) {
            case CONTRIBUTION: {
                return this.contributionBindingInitialization();
            }
            case MEMBERS_INJECTION: {
                return this.membersInjectionBindingInitialization();
            }
        }
        throw new AssertionError();
    }

    private CodeBlock contributionBindingInitialization() {
        ContributionBinding contributionBinding = this.resolvedBindings.contributionBinding();
        switch (contributionBinding.factoryCreationStrategy()) {
            case DELEGATE: {
                CodeBlock delegatingCodeBlock = CodeBlock.of((String)"($T) $L", (Object[])new Object[]{contributionBinding.bindingType().frameworkClass(), this.getDependencyExpression((FrameworkDependency)Iterables.getOnlyElement(contributionBinding.frameworkDependencies()))});
                return this.generatedComponentModel.decorateForScope(delegatingCodeBlock, contributionBinding.scope());
            }
            case SINGLETON_INSTANCE: {
                Preconditions.checkState((boolean)contributionBinding.scope().isPresent());
            }
            case CLASS_CONSTRUCTOR: {
                return this.factoryForContributionBindingInitialization(contributionBinding);
            }
        }
        throw new AssertionError();
    }

    private CodeBlock membersInjectionBindingInitialization() {
        MembersInjectionBinding membersInjectionBinding = this.resolvedBindings.membersInjectionBinding().get();
        return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{SourceFiles.membersInjectorNameForType(membersInjectionBinding.membersInjectedType()), CodeBlocks.makeParametersCodeBlock(this.getBindingDependencyExpressions(membersInjectionBinding))});
    }

    private CodeBlock factoryForContributionBindingInitialization(ContributionBinding binding) {
        TypeName bindingKeyTypeName = TypeName.get((TypeMirror)binding.key().type());
        switch (binding.bindingKind()) {
            case COMPONENT: {
                return CodeBlock.of((String)"$T.<$T>create(this)", (Object[])new Object[]{TypeNames.INSTANCE_FACTORY, bindingKeyTypeName});
            }
            case COMPONENT_DEPENDENCY: {
                return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.INSTANCE_FACTORY, this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forDependency(binding.key().type()), this.componentName)});
            }
            case COMPONENT_PROVISION: {
                TypeElement dependencyType = this.dependencyTypeForBinding(binding);
                String dependencyVariable = SourceFiles.simpleVariableName(dependencyType);
                String componentMethod = binding.bindingElement().get().getSimpleName().toString();
                CodeBlock invocation = ComponentProvisionBindingExpression.maybeCheckForNull((ProvisionBinding)binding, this.compilerOptions, CodeBlock.of((String)"$L.$L()", (Object[])new Object[]{dependencyVariable, componentMethod}));
                ClassName dependencyClassName = ClassName.get((TypeElement)dependencyType);
                String factoryName = dependencyClassName.toString().replace('.', '_') + "_" + componentMethod;
                MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(bindingKeyTypeName).addStatement("return $L", new Object[]{invocation});
                if (binding.nullableType().isPresent()) {
                    getMethod.addAnnotation(ClassName.get((TypeElement)MoreTypes.asTypeElement(binding.nullableType().get())));
                }
                this.generatedComponentModel.addType(TypeSpec.classBuilder((String)factoryName).addSuperinterface((TypeName)TypeNames.providerOf(bindingKeyTypeName)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField((TypeName)dependencyClassName, dependencyVariable, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)dependencyClassName, dependencyVariable, new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{dependencyVariable}).build()).addMethod(getMethod.build()).build());
                return CodeBlock.of((String)"new $L($L)", (Object[])new Object[]{factoryName, this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forDependency(dependencyType.asType()), this.componentName)});
            }
            case SUBCOMPONENT_BUILDER: {
                String subcomponentName = this.generatedComponentModel.getSubcomponentName((ComponentDescriptor)this.graph.componentDescriptor().subcomponentsByBuilderType().get((Object)MoreTypes.asTypeElement(binding.key().type())));
                return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)TypeNames.providerOf(bindingKeyTypeName)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(bindingKeyTypeName).addStatement("return new $LBuilder()", new Object[]{subcomponentName}).build()).build()});
            }
            case BUILDER_BINDING: {
                return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{InstanceFactory.class, binding.nullableType().isPresent() ? "createNullable" : "create", this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forBinding(binding), this.componentName)});
            }
            case INJECTION: 
            case PROVISION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.explicitDependencies().size() + 1));
                if (binding.requiresModuleInstance()) {
                    arguments.add(this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().asType()), this.componentName));
                }
                arguments.addAll(this.getBindingDependencyExpressions(binding));
                CodeBlock factoryCreate = CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments)});
                if (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) && binding.unresolved().isPresent() && binding.scope().isPresent()) {
                    factoryCreate = CodeBlock.of((String)"($T) $L", (Object[])new Object[]{binding.bindingType().frameworkClass(), factoryCreate});
                }
                return this.generatedComponentModel.decorateForScope(factoryCreate, binding.scope());
            }
            case COMPONENT_PRODUCTION: {
                TypeElement dependencyType = this.dependencyTypeForBinding(binding);
                FieldSpec dependencyField = FieldSpec.builder((TypeName)ClassName.get((TypeElement)dependencyType), (String)SourceFiles.simpleVariableName(dependencyType), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer(this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forDependency(dependencyType.asType()), this.componentName)).build();
                return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)TypeNames.producerOf(bindingKeyTypeName)).addField(dependencyField).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.listenableFutureOf(bindingKeyTypeName)).addStatement("return $N.$L()", new Object[]{dependencyField, binding.bindingElement().get().getSimpleName()}).build()).build()});
            }
            case PRODUCTION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 2));
                if (binding.requiresModuleInstance()) {
                    arguments.add(this.componentRequirementFields.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().asType()), this.componentName));
                }
                arguments.addAll(this.getBindingDependencyExpressions(binding));
                return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments)});
            }
            case SYNTHETIC_MULTIBOUND_SET: {
                return this.factoryForSetMultibindingInitialization(binding);
            }
            case SYNTHETIC_MULTIBOUND_MAP: {
                return this.factoryForMapMultibindingInitialization(binding);
            }
            case SYNTHETIC_RELEASABLE_REFERENCE_MANAGER: {
                return this.factoryForSyntheticReleasableReferenceManagerBindingInitialization(binding);
            }
            case SYNTHETIC_RELEASABLE_REFERENCE_MANAGERS: {
                return this.factoryForSyntheticSetOfReleasableReferenceManagersInitialization(binding);
            }
            case SYNTHETIC_OPTIONAL_BINDING: {
                return this.factoryForSyntheticOptionalBindingInitialization(binding);
            }
        }
        throw new AssertionError(binding);
    }

    private TypeElement dependencyTypeForBinding(ContributionBinding binding) {
        return (TypeElement)this.graph.componentDescriptor().dependencyMethodIndex().get((Object)binding.bindingElement().get());
    }

    private CodeBlock factoryForSetMultibindingInitialization(ContributionBinding binding) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.setFactoryClassName(binding)});
        boolean useRawTypes = this.useRawType();
        if (!useRawTypes) {
            SetType setType = SetType.from(binding.key());
            builder.add("<$T>", new Object[]{setType.elementsAreTypeOf(Produced.class) ? setType.unwrappedElementType(Produced.class) : setType.elementType()});
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        for (FrameworkDependency frameworkDependency : binding.frameworkDependencies()) {
            String methodName;
            ContributionType contributionType = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)frameworkDependency.bindingKey())).contributionType();
            String methodNameSuffix = frameworkDependency.frameworkClass().getSimpleName();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    methodName = "add" + methodNameSuffix;
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    methodName = "addCollection" + methodNameSuffix;
                    break;
                }
                default: {
                    throw new AssertionError((Object)(frameworkDependency + " is not a set multibinding"));
                }
            }
            builderMethodCalls.add(".$L($L)", new Object[]{methodName, this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyExpression(frameworkDependency))});
        }
        builder.add("builder($L, $L)", new Object[]{individualProviders, setProviders});
        builder.add(builderMethodCalls.build());
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock factoryForMapMultibindingInitialization(ContributionBinding binding) {
        ImmutableList<FrameworkDependency> frameworkDependencies = binding.frameworkDependencies();
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        MapType mapType = MapType.from(binding.key().type());
        CodeBlock.Builder builderCall = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.mapFactoryClassName(binding)});
        boolean useRawTypes = this.useRawType();
        if (!useRawTypes) {
            TypeMirror valueType = mapType.valueType();
            for (Class frameworkClass : ImmutableSet.of(Provider.class, Producer.class, Produced.class)) {
                if (!mapType.valuesAreTypeOf(frameworkClass)) continue;
                valueType = mapType.unwrappedValueType(frameworkClass);
                break;
            }
            builderCall.add("<$T, $T>", new Object[]{mapType.keyType(), valueType});
        }
        if (binding.bindingType().equals((Object)BindingType.PROVISION)) {
            builderCall.add("builder($L)", new Object[]{frameworkDependencies.size()});
        } else {
            builderCall.add("builder()", new Object[0]);
        }
        codeBlocks.add((Object)builderCall.build());
        for (FrameworkDependency frameworkDependency : frameworkDependencies) {
            BindingKey bindingKey = frameworkDependency.bindingKey();
            ContributionBinding contributionBinding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).contributionBinding();
            CodeBlock value = this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyExpression(frameworkDependency));
            codeBlocks.add((Object)CodeBlock.of((String)".put($L, $L)", (Object[])new Object[]{MapKeys.getMapKeyExpression(contributionBinding, this.componentName), value}));
        }
        codeBlocks.add((Object)CodeBlock.of((String)".build()", (Object[])new Object[0]));
        return CodeBlocks.concat((Iterable<CodeBlock>)codeBlocks.build());
    }

    private CodeBlock potentiallyCast(boolean shouldCast, Class<?> classToCast, CodeBlock notCasted) {
        if (!shouldCast) {
            return notCasted;
        }
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{classToCast, notCasted});
    }

    private boolean useRawType() {
        Optional<String> bindingPackage = this.resolvedBindings.binding().bindingPackage();
        return bindingPackage.isPresent() && !bindingPackage.get().equals(this.componentName.packageName());
    }

    private CodeBlock factoryForSyntheticReleasableReferenceManagerBindingInitialization(ContributionBinding binding) {
        CodeBlock managerExpression;
        Scope scope = this.forReleasableReferencesAnnotationValue(binding.key().qualifier().get());
        if (MoreTypes.isTypeOf(TypedReleasableReferenceManager.class, binding.key().type())) {
            TypeMirror metadataType = MoreTypes.asDeclared(binding.key().type()).getTypeArguments().get(0);
            managerExpression = this.typedReleasableReferenceManagerDecoratorExpression(this.generatedComponentModel.getReferenceReleasingProviderManagerExpression(scope), scope.releasableReferencesMetadata(metadataType).get());
        } else {
            managerExpression = this.generatedComponentModel.getReferenceReleasingProviderManagerExpression(scope);
        }
        TypeName keyType = TypeName.get((TypeMirror)binding.key().type());
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)TypeNames.providerOf(keyType)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyType).addCode("return $L;", new Object[]{managerExpression}).build()).build()});
    }

    private CodeBlock factoryForSyntheticSetOfReleasableReferenceManagersInitialization(ContributionBinding binding) {
        Key key = binding.key();
        SetType keyType = SetType.from(key);
        ImmutableList.Builder managerExpressions = ImmutableList.builder();
        for (Scope scope : this.graph.scopesRequiringReleasableReferenceManagers()) {
            CodeBlock releasableReferenceManagerExpression = this.generatedComponentModel.getReferenceReleasingProviderManagerExpression(scope);
            if (keyType.elementsAreTypeOf(ReleasableReferenceManager.class)) {
                managerExpressions.add((Object)releasableReferenceManagerExpression);
                continue;
            }
            if (keyType.elementsAreTypeOf(TypedReleasableReferenceManager.class)) {
                TypeMirror metadataType = keyType.unwrappedElementType(TypedReleasableReferenceManager.class);
                Optional<AnnotationMirror> metadata = scope.releasableReferencesMetadata(metadataType);
                if (!metadata.isPresent()) continue;
                managerExpressions.add((Object)this.typedReleasableReferenceManagerDecoratorExpression(releasableReferenceManagerExpression, metadata.get()));
                continue;
            }
            throw new IllegalArgumentException("inappropriate key: " + binding);
        }
        TypeName keyTypeName = TypeName.get((TypeMirror)key.type());
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)TypeNames.providerOf(keyTypeName)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyTypeName).addCode("return new $T($T.asList($L));", new Object[]{HashSet.class, Arrays.class, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)managerExpressions.build())}).build()).build()});
    }

    private CodeBlock typedReleasableReferenceManagerDecoratorExpression(CodeBlock managerExpression, AnnotationMirror metadata) {
        return CodeBlock.of((String)"new $T<$T>($L, $L)", (Object[])new Object[]{TypeNames.TYPED_RELEASABLE_REFERENCE_MANAGER_DECORATOR, metadata.getAnnotationType(), managerExpression, new AnnotationExpression(metadata).getAnnotationInstanceExpression()});
    }

    private Scope forReleasableReferencesAnnotationValue(AnnotationMirror annotation) {
        Preconditions.checkArgument((boolean)MoreTypes.isTypeOf(ForReleasableReferences.class, annotation.getAnnotationType()));
        return Scope.scope(MoreElements.asType(MoreTypes.asDeclared(MoreAnnotationMirrors.getTypeValue(annotation, "value")).asElement()));
    }

    private CodeBlock factoryForSyntheticOptionalBindingInitialization(ContributionBinding binding) {
        if (binding.explicitDependencies().isEmpty()) {
            Verify.verify((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Absent optional bindings should be provisions: %s", (Object[])new Object[]{binding});
            return this.optionalFactories.absentOptionalProvider(binding);
        }
        return this.optionalFactories.presentOptionalFactory(binding, this.getDependencyExpression((FrameworkDependency)Iterables.getOnlyElement(binding.frameworkDependencies())));
    }

    private ImmutableList<CodeBlock> getBindingDependencyExpressions(Binding binding) {
        ImmutableList<FrameworkDependency> dependencies = binding.frameworkDependencies();
        return dependencies.stream().map(this::getDependencyExpression).collect(Util.toImmutableList());
    }

    private CodeBlock getDependencyExpression(FrameworkDependency frameworkDependency) {
        return this.componentBindingExpressions.getDependencyExpression(frameworkDependency, this.componentName).codeBlock();
    }

    FrameworkFieldInitializer forProducerFromProvider() {
        return new FrameworkFieldInitializer(this.generatedComponentModel, this.componentBindingExpressions, this.componentRequirementFields, this.resolvedBindings, this.compilerOptions, this.graph, true, this.optionalFactories, this.componentName);
    }
}

