/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.TypeNames;
import java.util.Optional;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class FrameworkInstanceBindingExpression
extends BindingExpression {
    private final Optional<FieldSpec> fieldSpec;
    private final GeneratedComponentModel generatedComponentModel;
    private final MemberSelect memberSelect;
    private final FrameworkType frameworkType;
    private final FrameworkFieldInitializer fieldInitializer;
    private final DaggerTypes types;
    private final Elements elements;
    private InitializationState fieldInitializationState = InitializationState.UNINITIALIZED;

    static FrameworkInstanceBindingExpression create(ResolvedBindings resolvedBindings, Optional<FieldSpec> fieldSpec, GeneratedComponentModel generatedComponentModel, MemberSelect memberSelect, FrameworkFieldInitializer frameworkFieldInitializer, DaggerTypes types, Elements elements) {
        return new FrameworkInstanceBindingExpression(resolvedBindings, fieldSpec, generatedComponentModel, memberSelect, resolvedBindings.bindingType().frameworkType(), frameworkFieldInitializer, types, elements);
    }

    private FrameworkInstanceBindingExpression(ResolvedBindings resolvedBindings, Optional<FieldSpec> fieldSpec, GeneratedComponentModel generatedComponentModel, MemberSelect memberSelect, FrameworkType frameworkType, FrameworkFieldInitializer fieldInitializer, DaggerTypes types, Elements elements) {
        super(resolvedBindings);
        this.generatedComponentModel = generatedComponentModel;
        this.memberSelect = memberSelect;
        this.fieldSpec = fieldSpec;
        this.frameworkType = frameworkType;
        this.fieldInitializer = fieldInitializer;
        this.types = types;
        this.elements = elements;
    }

    FrameworkInstanceBindingExpression producerFromProvider(FieldSpec fieldSpec, ClassName componentName) {
        Preconditions.checkState((boolean)this.frameworkType.equals((Object)FrameworkType.PROVIDER));
        return new FrameworkInstanceBindingExpression(this.resolvedBindings(), Optional.of(fieldSpec), this.generatedComponentModel, MemberSelect.localField(componentName, fieldSpec.name), FrameworkType.PRODUCER, this.fieldInitializer.forProducerFromProvider(), this.types, this.elements);
    }

    @Override
    Expression getDependencyExpression(DependencyRequest.Kind requestKind, ClassName requestingClass) {
        this.maybeInitializeField();
        DeclaredType expressionType = Accessibility.isTypeAccessibleFrom(this.instanceType(), requestingClass.packageName()) || this.isInlinedFactoryCreation() ? this.types.wrapType(this.instanceType(), this.resolvedBindings().frameworkClass()) : this.rawFrameworkType();
        return this.frameworkType.to(requestKind, Expression.create(expressionType, this.memberSelect.getExpressionFor(requestingClass)), this.types);
    }

    private TypeMirror instanceType() {
        return this.resolvedBindings().membersInjectionBinding().map(binding -> binding.key().type()).orElseGet(() -> this.resolvedBindings().contributionBinding().contributedType());
    }

    private boolean isInlinedFactoryCreation() {
        return this.memberSelect.staticMember();
    }

    private DeclaredType rawFrameworkType() {
        return this.types.getDeclaredType(this.elements.getTypeElement(this.resolvedBindings().frameworkClass().getCanonicalName()), new TypeMirror[0]);
    }

    private String fieldName() {
        this.checkHasField();
        return this.fieldSpec.get().name;
    }

    private void setFieldInitializationState(InitializationState fieldInitializationState) {
        this.checkHasField();
        Preconditions.checkArgument((this.fieldInitializationState.compareTo(fieldInitializationState) < 0 ? 1 : 0) != 0);
        this.fieldInitializationState = fieldInitializationState;
    }

    private void checkHasField() {
        if (!this.fieldSpec.isPresent()) {
            throw new UnsupportedOperationException();
        }
    }

    private void maybeInitializeField() {
        if (!this.fieldSpec.isPresent()) {
            return;
        }
        switch (this.fieldInitializationState) {
            case UNINITIALIZED: {
                this.setFieldInitializationState(InitializationState.INITIALIZING);
                CodeBlock.Builder codeBuilder = CodeBlock.builder();
                CodeBlock initCode = CodeBlock.of((String)"this.$L = $L;", (Object[])new Object[]{this.fieldName(), Preconditions.checkNotNull((Object)this.fieldInitializer.getFieldInitialization())});
                if (this.fieldInitializationState == InitializationState.DELEGATED) {
                    String delegateFactoryVariable = this.fieldName() + "Delegate";
                    codeBuilder.add("$1T $2L = ($1T) $3L;", new Object[]{TypeNames.DELEGATE_FACTORY, delegateFactoryVariable, this.fieldName()}).add(initCode).add("$L.setDelegatedProvider($L);", new Object[]{delegateFactoryVariable, this.fieldName()}).build();
                } else {
                    codeBuilder.add(initCode);
                }
                this.generatedComponentModel.addInitialization(codeBuilder.build());
                this.generatedComponentModel.addField(this.fieldSpec.get());
                this.setFieldInitializationState(InitializationState.INITIALIZED);
                break;
            }
            case INITIALIZING: {
                this.generatedComponentModel.addInitialization(CodeBlock.of((String)"this.$L = new $T<>();", (Object[])new Object[]{this.fieldName(), TypeNames.DELEGATE_FACTORY}));
                this.setFieldInitializationState(InitializationState.DELEGATED);
                break;
            }
            case DELEGATED: 
            case INITIALIZED: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled initialization state: " + (Object)((Object)this.fieldInitializationState)));
            }
        }
    }

    private static enum InitializationState {
        UNINITIALIZED,
        INITIALIZING,
        DELEGATED,
        INITIALIZED;

    }
}

