/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.MapBuilder;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SimpleInvocationBindingExpression;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class MapBindingExpression
extends SimpleInvocationBindingExpression {
    private static final int MAX_IMMUTABLE_MAP_OF_KEY_VALUE_PAIRS = 5;
    private final ProvisionBinding binding;
    private final ImmutableMap<DependencyRequest, ContributionBinding> dependencies;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final Elements elements;

    MapBindingExpression(ProvisionBinding binding, BindingGraph graph, ComponentBindingExpressions componentBindingExpressions, BindingExpression delegate, DaggerTypes types, Elements elements) {
        super(delegate, types);
        ContributionBinding.Kind bindingKind = binding.bindingKind();
        Preconditions.checkArgument((boolean)bindingKind.equals((Object)ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_MAP), (Object)((Object)bindingKind));
        this.binding = binding;
        this.componentBindingExpressions = componentBindingExpressions;
        this.elements = elements;
        this.dependencies = Maps.toMap(binding.dependencies(), dep -> ((ResolvedBindings)graph.resolvedBindings().get((Object)dep.bindingKey())).contributionBinding());
    }

    @Override
    Expression getInstanceDependencyExpression(DependencyRequest.Kind requestKind, ClassName requestingClass) {
        return Expression.create(this.binding.key().type(), this.mapExpression(requestingClass));
    }

    private CodeBlock mapExpression(ClassName requestingClass) {
        boolean isImmutableMapAvailable = this.isImmutableMapAvailable();
        if (isImmutableMapAvailable && this.dependencies.size() <= 5) {
            return CodeBlock.builder().add("$T.", new Object[]{ImmutableMap.class}).add(this.maybeTypeParameters(requestingClass)).add("of($L)", new Object[]{this.dependencies.keySet().stream().map(dependency -> this.keyAndValueExpression((DependencyRequest)dependency, requestingClass)).collect(CodeBlocks.toParametersCodeBlock())}).build();
        }
        switch (this.dependencies.size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"emptyMap()", (Object[])new Object[0]));
            }
            case 1: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"singletonMap($L)", (Object[])new Object[]{this.keyAndValueExpression((DependencyRequest)Iterables.getOnlyElement((Iterable)this.dependencies.keySet()), requestingClass)}));
            }
        }
        CodeBlock.Builder instantiation = CodeBlock.builder();
        instantiation.add("$T.", new Object[]{isImmutableMapAvailable ? ImmutableMap.class : MapBuilder.class}).add(this.maybeTypeParameters(requestingClass));
        if (isImmutableMapAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newMapBuilder($L)", new Object[]{this.dependencies.size()});
        }
        for (DependencyRequest dependency2 : this.dependencies.keySet()) {
            instantiation.add(".put($L)", new Object[]{this.keyAndValueExpression(dependency2, requestingClass)});
        }
        return instantiation.add(".build()", new Object[0]).build();
    }

    private CodeBlock keyAndValueExpression(DependencyRequest dependency, ClassName requestingClass) {
        return CodeBlock.of((String)"$L, $L", (Object[])new Object[]{MapKeys.getMapKeyExpression((ContributionBinding)this.dependencies.get((Object)dependency), requestingClass), this.componentBindingExpressions.getDependencyExpression(dependency, requestingClass).codeBlock()});
    }

    private CodeBlock collectionsStaticFactoryInvocation(ClassName requestingClass, CodeBlock methodInvocation) {
        return CodeBlock.builder().add("$T.", new Object[]{Collections.class}).add(this.maybeTypeParameters(requestingClass)).add(methodInvocation).build();
    }

    private CodeBlock maybeTypeParameters(ClassName requestingClass) {
        TypeMirror bindingKeyType = this.binding.key().type();
        MapType mapType = MapType.from(this.binding.key());
        return Accessibility.isTypeAccessibleFrom(bindingKeyType, requestingClass.packageName()) ? CodeBlock.of((String)"<$T, $T>", (Object[])new Object[]{mapType.keyType(), mapType.valueType()}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isImmutableMapAvailable() {
        return this.elements.getTypeElement(ImmutableMap.class.getCanonicalName()) != null;
    }

    @Override
    protected CodeBlock explicitTypeParameter(ClassName requestingClass) {
        if (this.isImmutableMapAvailable()) {
            TypeMirror keyType = this.binding.key().type();
            return CodeBlock.of((String)"<$T>", (Object[])new Object[]{Accessibility.isTypeAccessibleFrom(keyType, requestingClass.packageName()) ? keyType : Map.class});
        }
        return CodeBlock.of((String)"", (Object[])new Object[0]);
    }
}

