/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Elements;

abstract class MembersInjectionBinding
extends Binding {
    MembersInjectionBinding() {
    }

    @Override
    Optional<? extends Element> bindingElement() {
        return Optional.of(this.membersInjectedType());
    }

    abstract TypeElement membersInjectedType();

    abstract Optional<MembersInjectionBinding> unresolved();

    @Override
    Optional<TypeElement> contributingModule() {
        return Optional.empty();
    }

    abstract ImmutableSortedSet<InjectionSite> injectionSites();

    abstract Optional<Key> parentKey();

    @Override
    public BindingType bindingType() {
        return BindingType.MEMBERS_INJECTION;
    }

    boolean hasLocalInjectionSites() {
        return this.injectionSites().stream().anyMatch(injectionSite -> injectionSite.element().getEnclosingElement().equals(this.membersInjectedType()));
    }

    static final class Factory {
        private final Elements elements;
        private final DaggerTypes types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private final ElementVisitor<Optional<InjectionSite>, DeclaredType> injectionSiteVisitor = new ElementKindVisitor6<Optional<InjectionSite>, DeclaredType>(Optional.empty()){

            @Override
            public Optional<InjectionSite> visitExecutableAsMethod(ExecutableElement e, DeclaredType type) {
                return Optional.of(this.injectionSiteForInjectMethod(e, type));
            }

            @Override
            public Optional<InjectionSite> visitVariableAsField(VariableElement e, DeclaredType type) {
                return MoreElements.isAnnotationPresent(e, Inject.class) && !e.getModifiers().contains((Object)Modifier.PRIVATE) && !e.getModifiers().contains((Object)Modifier.STATIC) ? Optional.of(this.injectionSiteForInjectField(e, type)) : Optional.empty();
            }
        };

        Factory(Elements elements, DaggerTypes types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
            this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
            this.keyFactory = (Key.Factory)Preconditions.checkNotNull((Object)keyFactory);
            this.dependencyRequestFactory = (DependencyRequest.Factory)Preconditions.checkNotNull((Object)dependencyRequestFactory);
        }

        private InjectionSite injectionSiteForInjectMethod(ExecutableElement methodElement, DeclaredType containingType) {
            Preconditions.checkNotNull((Object)methodElement);
            Preconditions.checkArgument((boolean)methodElement.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType resolved = MoreTypes.asExecutable(this.types.asMemberOf(containingType, methodElement));
            return new AutoValue_MembersInjectionBinding_InjectionSite(InjectionSite.Kind.METHOD, methodElement, this.dependencyRequestFactory.forRequiredResolvedVariables(methodElement.getParameters(), resolved.getParameterTypes()));
        }

        private InjectionSite injectionSiteForInjectField(VariableElement fieldElement, DeclaredType containingType) {
            Preconditions.checkNotNull((Object)fieldElement);
            Preconditions.checkArgument((boolean)fieldElement.getKind().equals((Object)ElementKind.FIELD));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(fieldElement, Inject.class));
            TypeMirror resolved = this.types.asMemberOf(containingType, fieldElement);
            return new AutoValue_MembersInjectionBinding_InjectionSite(InjectionSite.Kind.FIELD, fieldElement, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)this.dependencyRequestFactory.forRequiredResolvedVariable(fieldElement, resolved)));
        }

        boolean hasInjectedMembersIn(DeclaredType declaredType) {
            return !this.getInjectionSites(declaredType).isEmpty();
        }

        MembersInjectionBinding forInjectedType(DeclaredType declaredType, Optional<TypeMirror> resolvedType) {
            TypeElement typeElement;
            if (!declaredType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
                DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
                Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(declaredType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(declaredType));
                declaredType = resolved;
            }
            ImmutableSortedSet<InjectionSite> injectionSites = this.getInjectionSites(declaredType);
            ImmutableSet dependencies = FluentIterable.from(injectionSites).transformAndConcat(InjectionSite::dependencies).toSet();
            Optional<Key> parentKey = this.types.nonObjectSuperclass(declaredType).map(this.keyFactory::forMembersInjectedType);
            Key key = this.keyFactory.forMembersInjectedType(declaredType);
            return new AutoValue_MembersInjectionBinding(key, (ImmutableSet<DependencyRequest>)dependencies, typeElement, Binding.hasNonDefaultTypeParameters(typeElement = MoreElements.asType(declaredType.asElement()), key.type(), this.types) ? Optional.of(this.forInjectedType(MoreTypes.asDeclared(typeElement.asType()), Optional.empty())) : Optional.empty(), injectionSites, parentKey);
        }

        private ImmutableSortedSet<InjectionSite> getInjectionSites(DeclaredType declaredType) {
            HashSet<InjectionSite> injectionSites = new HashSet<InjectionSite>();
            ArrayList<TypeElement> ancestors = new ArrayList<TypeElement>();
            LinkedHashMultimap overriddenMethodMap = LinkedHashMultimap.create();
            Optional<DeclaredType> currentType = Optional.of(declaredType);
            while (currentType.isPresent()) {
                DeclaredType type = currentType.get();
                ancestors.add(MoreElements.asType(type.asElement()));
                for (Element element : type.asElement().getEnclosedElements()) {
                    Optional<InjectionSite> maybeInjectionSite = this.injectionSiteVisitor.visit(element, type);
                    if (!maybeInjectionSite.isPresent()) continue;
                    InjectionSite injectionSite2 = maybeInjectionSite.get();
                    if (this.shouldBeInjected(injectionSite2.element(), (SetMultimap<String, ExecutableElement>)overriddenMethodMap)) {
                        injectionSites.add(injectionSite2);
                    }
                    if (!injectionSite2.kind().equals((Object)InjectionSite.Kind.METHOD)) continue;
                    ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite2.element());
                    overriddenMethodMap.put((Object)injectionSiteMethod.getSimpleName().toString(), (Object)injectionSiteMethod);
                }
                currentType = this.types.nonObjectSuperclass(currentType.get());
            }
            return ImmutableSortedSet.copyOf(Comparator.comparing(injectionSite -> ancestors.indexOf(injectionSite.element().getEnclosingElement())).reversed().thenComparing(injectionSite -> injectionSite.element().getKind()).thenComparing(InjectionSite::indexAmongSiblingMembers), injectionSites);
        }

        private boolean shouldBeInjected(Element injectionSite, SetMultimap<String, ExecutableElement> overriddenMethodMap) {
            if (!MoreElements.isAnnotationPresent(injectionSite, Inject.class) || injectionSite.getModifiers().contains((Object)Modifier.PRIVATE) || injectionSite.getModifiers().contains((Object)Modifier.STATIC)) {
                return false;
            }
            if (injectionSite.getKind().isField()) {
                return true;
            }
            ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite);
            TypeElement injectionSiteType = MoreElements.asType(injectionSite.getEnclosingElement());
            for (ExecutableElement method : overriddenMethodMap.get((Object)injectionSiteMethod.getSimpleName().toString())) {
                if (!this.elements.overrides(method, injectionSiteMethod, injectionSiteType)) continue;
                return false;
            }
            return true;
        }
    }

    static abstract class InjectionSite {
        InjectionSite() {
        }

        abstract Kind kind();

        abstract Element element();

        abstract ImmutableSet<DependencyRequest> dependencies();

        int indexAmongSiblingMembers() {
            return this.element().getEnclosingElement().getEnclosedElements().indexOf(this.element());
        }

        int indexAmongAtInjectMembersWithSameSimpleName() {
            return this.element().getEnclosingElement().getEnclosedElements().stream().filter(element -> MoreElements.isAnnotationPresent(element, Inject.class)).filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE)).filter(element -> element.getSimpleName().equals(this.element().getSimpleName())).collect(Collectors.toList()).indexOf(this.element());
        }

        static enum Kind {
            FIELD,
            METHOD;

        }
    }
}

