/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SimpleInvocationBindingExpression;
import javax.lang.model.util.Types;

final class OptionalBindingExpression
extends SimpleInvocationBindingExpression {
    private final ProvisionBinding binding;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final Types types;

    OptionalBindingExpression(ProvisionBinding binding, BindingExpression delegate, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types) {
        super(delegate, types);
        this.binding = binding;
        this.componentBindingExpressions = componentBindingExpressions;
        this.types = types;
    }

    @Override
    Expression getInstanceDependencyExpression(DependencyRequest.Kind requestKind, ClassName requestingClass) {
        OptionalType optionalType = OptionalType.from(this.binding.key());
        OptionalType.OptionalKind optionalKind = optionalType.kind();
        if (this.binding.dependencies().isEmpty()) {
            if (requestKind.equals((Object)DependencyRequest.Kind.FUTURE) && Accessibility.isTypeAccessibleFrom(this.binding.key().type(), requestingClass.packageName())) {
                return Expression.create(this.binding.key().type(), optionalKind.parameterizedAbsentValueExpression(optionalType));
            }
            return Expression.create(this.binding.key().type(), optionalKind.absentValueExpression());
        }
        DependencyRequest dependency = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
        CodeBlock dependencyExpression = this.componentBindingExpressions.getDependencyExpression(dependency, requestingClass).codeBlock();
        return Accessibility.isTypeAccessibleFrom(dependency.key().type(), requestingClass.packageName()) ? Expression.create(this.binding.key().type(), optionalKind.presentExpression(dependencyExpression)) : Expression.create(this.types.erasure(this.binding.key().type()), optionalKind.presentObjectExpression(dependencyExpression));
    }
}

