/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AutoValue_OptionalType;
import dagger.internal.codegen.Key;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;

abstract class OptionalType {
    private static final TypeVisitor<Optional<OptionalKind>, Void> OPTIONAL_KIND = new SimpleTypeVisitor8<Optional<OptionalKind>, Void>(Optional.empty()){

        @Override
        public Optional<OptionalKind> visitDeclared(DeclaredType t, Void p) {
            for (OptionalKind optionalKind : OptionalKind.values()) {
                Name qualifiedName = MoreElements.asType(t.asElement()).getQualifiedName();
                if (!qualifiedName.contentEquals(optionalKind.clazz.getCanonicalName())) continue;
                return Optional.of(optionalKind);
            }
            return Optional.empty();
        }
    };

    OptionalType() {
    }

    @Deprecated
    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredOptionalType();

    DeclaredType declaredOptionalType() {
        return (DeclaredType)this.wrappedDeclaredOptionalType().get();
    }

    OptionalKind kind() {
        return this.declaredOptionalType().accept(OPTIONAL_KIND, null).get();
    }

    TypeMirror valueType() {
        return this.declaredOptionalType().getTypeArguments().get(0);
    }

    static boolean isOptional(TypeMirror type) {
        return type.accept(OPTIONAL_KIND, null).isPresent();
    }

    static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type());
    }

    static OptionalType from(TypeMirror type) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type), (String)"%s must be an Optional", (Object)type);
        return new AutoValue_OptionalType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type)));
    }

    static OptionalType from(Key key) {
        return OptionalType.from(key.type());
    }

    static enum OptionalKind {
        GUAVA_OPTIONAL(com.google.common.base.Optional.class, "absent"),
        JDK_OPTIONAL(Optional.class, "empty");

        private final Class<?> clazz;
        private final String absentFactoryMethodName;

        private OptionalKind(Class<?> clazz, String absentFactoryMethodName) {
            this.clazz = clazz;
            this.absentFactoryMethodName = absentFactoryMethodName;
        }

        ParameterizedTypeName of(TypeName valueType) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(this.clazz), (TypeName[])new TypeName[]{valueType});
        }

        CodeBlock absentValueExpression() {
            return CodeBlock.of((String)"$T.$L()", (Object[])new Object[]{this.clazz, this.absentFactoryMethodName});
        }

        CodeBlock parameterizedAbsentValueExpression(OptionalType optionalType) {
            return CodeBlock.of((String)"$T.<$T>$L()", (Object[])new Object[]{this.clazz, optionalType.valueType(), this.absentFactoryMethodName});
        }

        CodeBlock presentExpression(CodeBlock value) {
            return CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{this.clazz, value});
        }

        CodeBlock presentObjectExpression(CodeBlock value) {
            return CodeBlock.of((String)"$T.<$T>of($L)", (Object[])new Object[]{this.clazz, Object.class, value});
        }
    }
}

