/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ResolvedBindings;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.EnumMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class PrivateMethodBindingExpression
extends BindingExpression {
    private final ClassName componentName;
    private final GeneratedComponentModel generatedComponentModel;
    private final BindingExpression delegate;
    private final Map<DependencyRequest.Kind, String> methodNames = new EnumMap<DependencyRequest.Kind, String>(DependencyRequest.Kind.class);
    private final ContributionBinding binding;
    private final DaggerTypes types;
    private final Elements elements;

    PrivateMethodBindingExpression(ResolvedBindings resolvedBindings, ClassName componentName, GeneratedComponentModel generatedComponentModel, BindingExpression delegate, DaggerTypes types, Elements elements) {
        super(resolvedBindings);
        this.componentName = componentName;
        this.generatedComponentModel = generatedComponentModel;
        this.delegate = delegate;
        this.binding = resolvedBindings.contributionBinding();
        this.types = types;
        this.elements = elements;
    }

    @Override
    Expression getDependencyExpression(DependencyRequest.Kind requestKind, ClassName requestingClass) {
        if (!this.methodNames.containsKey((Object)requestKind)) {
            String name = this.generatedComponentModel.getUniqueMethodName(this.methodName(requestKind));
            this.methodNames.put(requestKind, name);
            this.createMethod(name, requestKind);
        }
        CodeBlock invocation = this.componentName.equals((Object)requestingClass) ? CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodNames.get((Object)requestKind)}) : CodeBlock.of((String)"$T.this.$N()", (Object[])new Object[]{this.componentName, this.methodNames.get((Object)requestKind)});
        return Expression.create(this.returnType(requestKind), invocation);
    }

    private void createMethod(String name, DependencyRequest.Kind requestKind) {
        this.generatedComponentModel.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.get((TypeMirror)this.returnType(requestKind))).addStatement("return $L", new Object[]{this.methodBody(requestKind)}).build());
    }

    private TypeMirror returnType(DependencyRequest.Kind requestKind) {
        switch (requestKind) {
            case INSTANCE: {
                return this.binding.contributesPrimitiveType() ? MoreElements.asExecutable(this.binding.bindingElement().get()).getReturnType() : this.instanceType();
            }
            case LAZY: {
                return this.accessibleType(this.types.lazyOf(this.instanceType()));
            }
            case PROVIDER_OF_LAZY: {
                return this.accessibleType(this.types.providerOfLazyOf(this.instanceType()));
            }
            case PROVIDER: {
                return this.accessibleType(this.types.providerOf(this.instanceType()));
            }
            case PRODUCER: {
                return this.accessibleType(this.types.producerOf(this.instanceType()));
            }
        }
        throw new AssertionError((Object)("Unhandled DependencyRequest: " + (Object)((Object)requestKind)));
    }

    private TypeMirror instanceType() {
        return this.accessibleType(this.binding.contributedType());
    }

    private CodeBlock methodBody(DependencyRequest.Kind requestKind) {
        switch (requestKind) {
            case PROVIDER: {
                return CodeBlock.of((String)"$L", (Object[])new Object[]{this.providerTypeSpec()});
            }
            case LAZY: 
            case PROVIDER_OF_LAZY: {
                return FrameworkType.PROVIDER.to(requestKind, this.getDependencyExpression(DependencyRequest.Kind.PROVIDER, this.componentName).codeBlock());
            }
            case INSTANCE: 
            case PRODUCER: {
                return this.delegate.getDependencyExpression(requestKind, this.componentName).codeBlock();
            }
        }
        throw new AssertionError((Object)("Unhandled DependencyRequest: " + (Object)((Object)requestKind)));
    }

    private TypeSpec providerTypeSpec() {
        return TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface(TypeName.get((TypeMirror)this.returnType(DependencyRequest.Kind.PROVIDER))).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)this.instanceType())).addStatement("return $L", new Object[]{this.getDependencyExpression(DependencyRequest.Kind.INSTANCE, this.componentName).codeBlock()}).build()).build();
    }

    private String methodName(DependencyRequest.Kind dependencyKind) {
        return String.format("get%s%s", this.bindingName(), PrivateMethodBindingExpression.dependencyKindName(dependencyKind));
    }

    private String bindingName() {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, BindingVariableNamer.name(this.binding));
    }

    private static String dependencyKindName(DependencyRequest.Kind kind) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, kind.name());
    }

    private TypeMirror accessibleType(TypeMirror typeMirror) {
        if (Accessibility.isTypeAccessibleFrom(typeMirror, this.componentName.packageName())) {
            return typeMirror;
        }
        if (Accessibility.isRawTypeAccessible(typeMirror, this.componentName.packageName()) && typeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            return this.types.getDeclaredType(MoreTypes.asTypeElement(typeMirror), new TypeMirror[0]);
        }
        return this.elements.getTypeElement(Object.class.getCanonicalName()).asType();
    }
}

