/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class ProvisionBinding
extends ContributionBinding {
    ProvisionBinding() {
    }

    @Override
    ImmutableSet<DependencyRequest> explicitDependencies() {
        return ImmutableSet.builder().addAll(this.provisionDependencies()).addAll(this.membersInjectionDependencies()).build();
    }

    abstract ImmutableSet<DependencyRequest> provisionDependencies();

    ImmutableSet<DependencyRequest> membersInjectionDependencies() {
        return this.injectionSites().stream().flatMap(i -> i.dependencies().stream()).collect(Util.toImmutableSet());
    }

    abstract ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites();

    @Override
    public BindingType bindingType() {
        return BindingType.PROVISION;
    }

    abstract Optional<ProvisionBinding> unresolved();

    @Override
    abstract Optional<Scope> scope();

    private static Builder builder() {
        return new .AutoValue_ProvisionBinding.Builder().provisionDependencies((ImmutableSet<DependencyRequest>)ImmutableSet.of()).injectionSites((ImmutableSortedSet<MembersInjectionBinding.InjectionSite>)ImmutableSortedSet.of());
    }

    abstract Builder toBuilder();

    boolean shouldCheckForNull(CompilerOptions compilerOptions) {
        return !this.contributesPrimitiveType() && !this.nullableType().isPresent() && compilerOptions.doCheckForNulls();
    }

    static final class Factory {
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private final MembersInjectionBinding.Factory membersInjectionBindingFactory;

        Factory(Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory, MembersInjectionBinding.Factory membersInjectionBindingFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
            this.membersInjectionBindingFactory = membersInjectionBindingFactory;
        }

        ProvisionBinding forInjectConstructor(ExecutableElement constructorElement, Optional<TypeMirror> resolvedType) {
            Key key;
            Preconditions.checkNotNull((Object)constructorElement);
            Preconditions.checkArgument((boolean)constructorElement.getKind().equals((Object)ElementKind.CONSTRUCTOR));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(constructorElement, Inject.class));
            Preconditions.checkArgument((!InjectionAnnotations.getQualifier(constructorElement).isPresent() ? 1 : 0) != 0);
            ExecutableType cxtorType = MoreTypes.asExecutable(constructorElement.asType());
            DeclaredType enclosingCxtorType = MoreTypes.asDeclared(constructorElement.getEnclosingElement().asType());
            if (!enclosingCxtorType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
                DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
                Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(enclosingCxtorType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(enclosingCxtorType));
                cxtorType = MoreTypes.asExecutable(this.types.asMemberOf(resolved, constructorElement));
                enclosingCxtorType = resolved;
            }
            Preconditions.checkArgument((!(key = this.keyFactory.forInjectConstructorWithResolvedType(enclosingCxtorType)).qualifier().isPresent() ? 1 : 0) != 0);
            ImmutableSet<DependencyRequest> provisionDependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(constructorElement.getParameters(), cxtorType.getParameterTypes());
            ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites = this.membersInjectionBindingFactory.forInjectedType(enclosingCxtorType, Optional.empty()).injectionSites();
            Builder builder = ((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(constructorElement)).key(key)).provisionDependencies(provisionDependencies).injectionSites(injectionSites).bindingKind(ContributionBinding.Kind.INJECTION)).scope(Scope.uniqueScopeOf(constructorElement.getEnclosingElement()));
            TypeElement bindingTypeElement = MoreElements.asType(constructorElement.getEnclosingElement());
            if (Binding.hasNonDefaultTypeParameters(bindingTypeElement, key.type(), this.types)) {
                builder.unresolved(this.forInjectConstructor(constructorElement, Optional.empty()));
            }
            return builder.build();
        }

        ProvisionBinding forProvidesMethod(ExecutableElement providesMethod, TypeElement contributedBy) {
            Preconditions.checkArgument((boolean)providesMethod.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributedBy.asType()), providesMethod));
            Key key = this.keyFactory.forProvidesMethod(providesMethod, contributedBy);
            ImmutableSet<DependencyRequest> dependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(providesMethod.getParameters(), resolvedMethod.getParameterTypes());
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.fromBindingMethod(providesMethod))).bindingElement(providesMethod)).contributingModule(contributedBy)).key(key)).provisionDependencies(dependencies).nullableType(ConfigurationAnnotations.getNullableType(providesMethod))).wrappedMapKey(MoreAnnotationMirrors.wrapOptionalInEquivalence(MapKeys.getMapKey(providesMethod)))).bindingKind(ContributionBinding.Kind.PROVISION)).scope(Scope.uniqueScopeOf(providesMethod)).build();
        }

        ProvisionBinding syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions) {
            return ((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(key)).provisionDependencies(this.dependencyRequestFactory.forMultibindingContributions(key, multibindingContributions)).bindingKind(ContributionBinding.Kind.forMultibindingKey(key))).build();
        }

        ProvisionBinding forComponent(TypeElement componentDefinitionType) {
            Preconditions.checkNotNull((Object)componentDefinitionType);
            return ((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(componentDefinitionType)).key(this.keyFactory.forType(componentDefinitionType.asType()))).bindingKind(ContributionBinding.Kind.COMPONENT)).build();
        }

        ProvisionBinding forComponentDependency(TypeElement dependencyType) {
            Preconditions.checkNotNull((Object)dependencyType);
            return ((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(dependencyType)).key(this.keyFactory.forType(dependencyType.asType()))).bindingKind(ContributionBinding.Kind.COMPONENT_DEPENDENCY)).build();
        }

        ProvisionBinding forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)componentMethod.getParameters().isEmpty());
            return ((Builder)((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(componentMethod)).key(this.keyFactory.forComponentMethod(componentMethod))).nullableType(ConfigurationAnnotations.getNullableType(componentMethod))).bindingKind(ContributionBinding.Kind.COMPONENT_PROVISION)).scope(Scope.uniqueScopeOf(componentMethod)).build();
        }

        ProvisionBinding forBuilderBinding(ComponentDescriptor.BuilderRequirementMethod method) {
            ExecutableElement builderMethod = method.method();
            Preconditions.checkNotNull((Object)builderMethod);
            Preconditions.checkArgument((boolean)builderMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((builderMethod.getParameters().size() == 1 ? 1 : 0) != 0);
            VariableElement parameterElement = (VariableElement)Iterables.getOnlyElement(builderMethod.getParameters());
            return ((Builder)((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(builderMethod)).key(method.requirement().key().get())).nullableType(ConfigurationAnnotations.getNullableType(parameterElement))).bindingKind(ContributionBinding.Kind.BUILDER_BINDING)).build();
        }

        ProvisionBinding forSubcomponentBuilderMethod(ExecutableElement subcomponentBuilderMethod, TypeElement contributedBy) {
            Preconditions.checkNotNull((Object)subcomponentBuilderMethod);
            Preconditions.checkArgument((boolean)subcomponentBuilderMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)subcomponentBuilderMethod.getParameters().isEmpty());
            DeclaredType declaredContainer = MoreTypes.asDeclared(contributedBy.asType());
            return ((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(subcomponentBuilderMethod)).key(this.keyFactory.forSubcomponentBuilderMethod(subcomponentBuilderMethod, declaredContainer))).bindingKind(ContributionBinding.Kind.SUBCOMPONENT_BUILDER)).build();
        }

        ProvisionBinding syntheticSubcomponentBuilder(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
            SubcomponentDeclaration subcomponentDeclaration = (SubcomponentDeclaration)subcomponentDeclarations.iterator().next();
            return ((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(subcomponentDeclaration.key())).bindingKind(ContributionBinding.Kind.SUBCOMPONENT_BUILDER)).build();
        }

        ProvisionBinding delegate(DelegateDeclaration delegateDeclaration, ProvisionBinding delegate) {
            return ((Builder)this.delegateBuilder(delegateDeclaration).nullableType(delegate.nullableType())).build();
        }

        ProvisionBinding missingDelegate(DelegateDeclaration delegateDeclaration) {
            return this.delegateBuilder(delegateDeclaration).build();
        }

        private Builder delegateBuilder(DelegateDeclaration delegateDeclaration) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(delegateDeclaration.contributionType())).bindingElement(delegateDeclaration.bindingElement().get())).contributingModule(delegateDeclaration.contributingModule().get())).key(this.keyFactory.forDelegateBinding(delegateDeclaration, Provider.class))).provisionDependencies(delegateDeclaration.delegateRequest()).wrappedMapKey(delegateDeclaration.wrappedMapKey())).bindingKind(ContributionBinding.Kind.SYNTHETIC_DELEGATE_BINDING)).scope(Scope.uniqueScopeOf(delegateDeclaration.bindingElement().get()));
        }

        ProvisionBinding provideReleasableReferenceManager(Scope scope) {
            return ((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(this.keyFactory.forReleasableReferenceManager(scope))).bindingKind(ContributionBinding.Kind.SYNTHETIC_RELEASABLE_REFERENCE_MANAGER)).build();
        }

        ProvisionBinding provideTypedReleasableReferenceManager(Scope scope, DeclaredType metadataType) {
            return ((Builder)this.provideReleasableReferenceManager(scope).toBuilder().key(this.keyFactory.forTypedReleasableReferenceManager(scope, metadataType))).build();
        }

        ProvisionBinding provideSetOfReleasableReferenceManagers() {
            return ((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(this.keyFactory.forSetOfReleasableReferenceManagers())).bindingKind(ContributionBinding.Kind.SYNTHETIC_RELEASABLE_REFERENCE_MANAGERS)).build();
        }

        ProvisionBinding provideSetOfTypedReleasableReferenceManagers(DeclaredType metadataType) {
            return ((Builder)this.provideSetOfReleasableReferenceManagers().toBuilder().key(this.keyFactory.forSetOfTypedReleasableReferenceManagers(metadataType))).build();
        }

        ProvisionBinding syntheticAbsentBinding(Key key) {
            return ((Builder)((Builder)((Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(key)).bindingKind(ContributionBinding.Kind.SYNTHETIC_OPTIONAL_BINDING)).build();
        }

        ProvisionBinding syntheticPresentBinding(Key key, DependencyRequest.Kind kind) {
            return this.syntheticAbsentBinding(key).toBuilder().provisionDependencies(this.dependencyRequestFactory.forSyntheticPresentOptionalBinding(key, kind)).build();
        }
    }

    @CanIgnoreReturnValue
    static abstract class Builder
    extends ContributionBinding.Builder<Builder> {
        Builder() {
        }

        abstract Builder provisionDependencies(DependencyRequest ... var1);

        abstract Builder provisionDependencies(ImmutableSet<DependencyRequest> var1);

        abstract Builder injectionSites(ImmutableSortedSet<MembersInjectionBinding.InjectionSite> var1);

        abstract Builder unresolved(ProvisionBinding var1);

        abstract Builder scope(Optional<Scope> var1);

        @CheckReturnValue
        abstract ProvisionBinding build();
    }
}

