/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.SetBuilder;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SimpleInvocationBindingExpression;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class SetBindingExpression
extends SimpleInvocationBindingExpression {
    private final ProvisionBinding binding;
    private final BindingGraph graph;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final Elements elements;

    SetBindingExpression(ProvisionBinding binding, BindingGraph graph, ComponentBindingExpressions componentBindingExpressions, BindingExpression delegate, DaggerTypes types, Elements elements) {
        super(delegate, types);
        this.binding = binding;
        this.graph = graph;
        this.componentBindingExpressions = componentBindingExpressions;
        this.elements = elements;
    }

    @Override
    Expression getInstanceDependencyExpression(DependencyRequest.Kind requestKind, ClassName requestingClass) {
        return Expression.create(this.binding.key().type(), this.setExpression(requestingClass));
    }

    private CodeBlock setExpression(ClassName requestingClass) {
        boolean isImmutableSetAvailable = this.isImmutableSetAvailable();
        if (isImmutableSetAvailable && this.binding.dependencies().stream().allMatch(this::isSingleValue)) {
            return CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("of($L)", new Object[]{this.binding.dependencies().stream().map(dependency -> this.getContributionExpression((DependencyRequest)dependency, requestingClass)).collect(CodeBlocks.toParametersCodeBlock())}).build();
        }
        switch (this.binding.dependencies().size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"emptySet()", (Object[])new Object[0]));
            }
            case 1: {
                DependencyRequest dependency2 = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
                CodeBlock contributionExpression = this.getContributionExpression(dependency2, requestingClass);
                if (this.isSingleValue(dependency2)) {
                    return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"singleton($L)", (Object[])new Object[]{contributionExpression}));
                }
                if (!isImmutableSetAvailable) break;
                return CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("copyOf($L)", new Object[]{contributionExpression}).build();
            }
        }
        CodeBlock.Builder instantiation = CodeBlock.builder();
        instantiation.add("$T.", new Object[]{isImmutableSetAvailable ? ImmutableSet.class : SetBuilder.class}).add(this.maybeTypeParameter(requestingClass));
        if (isImmutableSetAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newSetBuilder($L)", new Object[]{this.binding.dependencies().size()});
        }
        for (DependencyRequest dependency3 : this.binding.dependencies()) {
            String builderMethod = this.isSingleValue(dependency3) ? "add" : "addAll";
            instantiation.add(".$L($L)", new Object[]{builderMethod, this.getContributionExpression(dependency3, requestingClass)});
        }
        return instantiation.add(".build()", new Object[0]).build();
    }

    private CodeBlock getContributionExpression(DependencyRequest dependency, ClassName requestingClass) {
        return this.componentBindingExpressions.getDependencyExpression(dependency, requestingClass).codeBlock();
    }

    private CodeBlock collectionsStaticFactoryInvocation(ClassName requestingClass, CodeBlock methodInvocation) {
        return CodeBlock.builder().add("$T.", new Object[]{Collections.class}).add(this.maybeTypeParameter(requestingClass)).add(methodInvocation).build();
    }

    private CodeBlock maybeTypeParameter(ClassName requestingClass) {
        TypeMirror elementType = SetType.from(this.binding.key()).elementType();
        return Accessibility.isTypeAccessibleFrom(elementType, requestingClass.packageName()) ? CodeBlock.of((String)"<$T>", (Object[])new Object[]{elementType}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isSingleValue(DependencyRequest dependency) {
        return ((ResolvedBindings)this.graph.resolvedBindings().get((Object)dependency.bindingKey())).contributionBinding().contributionType().equals((Object)ContributionType.SET);
    }

    private boolean isImmutableSetAvailable() {
        return this.elements.getTypeElement(ImmutableSet.class.getCanonicalName()) != null;
    }

    @Override
    protected CodeBlock explicitTypeParameter(ClassName requestingClass) {
        if (this.isImmutableSetAvailable()) {
            TypeMirror keyType = this.binding.key().type();
            return CodeBlock.of((String)"<$T>", (Object[])new Object[]{Accessibility.isTypeAccessibleFrom(keyType, requestingClass.packageName()) ? keyType : Set.class});
        }
        return CodeBlock.of((String)"", (Object[])new Object[0]);
    }
}

