/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;

abstract class SimpleInvocationBindingExpression
extends BindingExpression {
    private final BindingExpression delegate;
    private final DaggerTypes types;

    SimpleInvocationBindingExpression(BindingExpression delegate, DaggerTypes types) {
        super(delegate.resolvedBindings());
        this.delegate = delegate;
        this.types = types;
    }

    abstract Expression getInstanceDependencyExpression(DependencyRequest.Kind var1, ClassName var2);

    protected CodeBlock explicitTypeParameter(ClassName requestingClass) {
        return CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    @Override
    final Expression getDependencyExpression(DependencyRequest.Kind requestKind, ClassName requestingClass) {
        switch (requestKind) {
            case INSTANCE: {
                return this.getInstanceDependencyExpression(requestKind, requestingClass);
            }
            case FUTURE: {
                Expression expression = this.getInstanceDependencyExpression(requestKind, requestingClass);
                return Expression.create(this.types.wrapType(expression.type(), ListenableFuture.class), CodeBlock.builder().add("$T.", new Object[]{Futures.class}).add(this.explicitTypeParameter(requestingClass)).add("immediateFuture($L)", new Object[]{expression.codeBlock()}).build());
            }
        }
        return this.delegate.getDependencyExpression(requestKind, requestingClass);
    }
}

