/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyVariableNamer;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.Optionals;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.Util;
import dagger.producers.Produced;
import dagger.producers.Producer;
import java.util.Comparator;
import java.util.List;
import javax.inject.Provider;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

class SourceFiles {
    private static final Joiner CLASS_FILE_NAME_JOINER = Joiner.on((char)'_');
    static final Comparator<DependencyRequest> DEPENDENCY_ORDERING = Comparator.comparing(request -> request.requestElement().map(Element::getKind), Optionals.optionalComparator()).thenComparing(DependencyRequest::kind).thenComparing(request -> request.requestElement().map(element -> element.getSimpleName().toString()), Optionals.optionalComparator());

    static ImmutableMap<BindingKey, FrameworkField> generateBindingFieldsForDependencies(Binding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"binding must be unresolved: %s", (Object)binding);
        ImmutableMap.Builder bindingFields = ImmutableMap.builder();
        for (Binding.DependencyAssociation dependencyAssociation : binding.dependencyAssociations()) {
            FrameworkDependency frameworkDependency = dependencyAssociation.frameworkDependency();
            bindingFields.put((Object)frameworkDependency.bindingKey(), (Object)FrameworkField.create(ClassName.get(frameworkDependency.frameworkClass()), TypeName.get((TypeMirror)frameworkDependency.bindingKey().key().type()), SourceFiles.fieldNameForDependency(dependencyAssociation.dependencyRequests())));
        }
        return bindingFields.build();
    }

    private static String fieldNameForDependency(ImmutableSet<DependencyRequest> dependencyRequests) {
        ImmutableSet dependencyNames = dependencyRequests.stream().map(DependencyVariableNamer::name).collect(Util.toImmutableSet());
        if (dependencyNames.size() == 1) {
            return (String)Iterables.getOnlyElement(dependencyNames);
        }
        UnmodifiableIterator namesIterator = dependencyNames.iterator();
        String first = (String)namesIterator.next();
        StringBuilder compositeNameBuilder = new StringBuilder(first);
        while (namesIterator.hasNext()) {
            compositeNameBuilder.append("And").append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, (String)namesIterator.next()));
        }
        return compositeNameBuilder.toString();
    }

    static CodeBlock frameworkTypeUsageStatement(CodeBlock frameworkTypeMemberSelect, DependencyRequest.Kind dependencyKind) {
        switch (dependencyKind) {
            case LAZY: {
                return CodeBlock.of((String)"$T.lazy($L)", (Object[])new Object[]{TypeNames.DOUBLE_CHECK, frameworkTypeMemberSelect});
            }
            case INSTANCE: 
            case FUTURE: {
                return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{frameworkTypeMemberSelect});
            }
            case PROVIDER: 
            case PRODUCER: 
            case MEMBERS_INJECTOR: {
                return frameworkTypeMemberSelect;
            }
            case PROVIDER_OF_LAZY: {
                return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.PROVIDER_OF_LAZY, frameworkTypeMemberSelect});
            }
        }
        throw new AssertionError((Object)dependencyKind);
    }

    static ImmutableMap<DependencyRequest, CodeBlock> frameworkFieldUsages(ImmutableSet<DependencyRequest> dependencies, ImmutableMap<BindingKey, FieldSpec> fields) {
        return Maps.toMap(dependencies, dep -> SourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{fields.get((Object)dep.bindingKey())}), dep.kind()));
    }

    static ClassName generatedClassNameForBinding(Binding binding) {
        switch (binding.bindingType()) {
            case PROVISION: 
            case PRODUCTION: {
                ContributionBinding contribution = (ContributionBinding)binding;
                Preconditions.checkArgument((boolean)contribution.bindingTypeElement().isPresent());
                ClassName enclosingClassName = ClassName.get((TypeElement)contribution.bindingTypeElement().get());
                switch (contribution.bindingKind()) {
                    case INJECTION: 
                    case PROVISION: 
                    case PRODUCTION: {
                        return enclosingClassName.topLevelClassName().peerClass(SourceFiles.classFileName(enclosingClassName) + "_" + SourceFiles.factoryPrefix(contribution) + "Factory");
                    }
                }
                throw new AssertionError();
            }
            case MEMBERS_INJECTION: {
                return SourceFiles.membersInjectorNameForType(((MembersInjectionBinding)binding).membersInjectedType());
            }
        }
        throw new AssertionError();
    }

    static TypeName parameterizedGeneratedTypeNameForBinding(Binding binding) {
        ClassName className = SourceFiles.generatedClassNameForBinding(binding);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        return typeParameters.isEmpty() ? className : ParameterizedTypeName.get((ClassName)className, (TypeName[])((TypeName[])Iterables.toArray(typeParameters, TypeName.class)));
    }

    static ClassName membersInjectorNameForType(TypeElement typeElement) {
        return SourceFiles.siblingClassName(typeElement, "_MembersInjector");
    }

    static String classFileName(ClassName className) {
        return CLASS_FILE_NAME_JOINER.join((Iterable)className.simpleNames());
    }

    static ClassName generatedMonitoringModuleName(TypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_MonitoringModule");
    }

    static ClassName generatedProductionExecutorModuleName(TypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_ProductionExecutorModule");
    }

    private static ClassName siblingClassName(TypeElement typeElement, String suffix) {
        ClassName className = ClassName.get((TypeElement)typeElement);
        return className.topLevelClassName().peerClass(SourceFiles.classFileName(className) + suffix);
    }

    static ClassName setFactoryClassName(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.bindingKind().equals((Object)ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_SET));
        if (binding.bindingType().equals((Object)BindingType.PROVISION)) {
            return TypeNames.SET_FACTORY;
        }
        SetType setType = SetType.from(binding.key());
        return setType.elementsAreTypeOf(Produced.class) ? TypeNames.SET_OF_PRODUCED_PRODUCER : TypeNames.SET_PRODUCER;
    }

    static ClassName mapFactoryClassName(ContributionBinding binding) {
        Preconditions.checkState((boolean)binding.bindingKind().equals((Object)ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_MAP), (Object)((Object)binding.bindingKind()));
        MapType mapType = MapType.from(binding.key());
        switch (binding.bindingType()) {
            case PROVISION: {
                return mapType.valuesAreTypeOf(Provider.class) ? TypeNames.MAP_PROVIDER_FACTORY : TypeNames.MAP_FACTORY;
            }
            case PRODUCTION: {
                return mapType.valuesAreFrameworkType() ? (mapType.valuesAreTypeOf(Producer.class) ? TypeNames.MAP_OF_PRODUCER_PRODUCER : TypeNames.MAP_OF_PRODUCED_PRODUCER) : TypeNames.MAP_PRODUCER;
            }
        }
        throw new IllegalArgumentException(binding.bindingType().toString());
    }

    private static String factoryPrefix(ContributionBinding binding) {
        switch (binding.bindingKind()) {
            case INJECTION: {
                return "";
            }
            case PROVISION: 
            case PRODUCTION: {
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, binding.bindingElement().get().getSimpleName().toString());
            }
        }
        throw new IllegalArgumentException();
    }

    static ImmutableList<TypeVariableName> bindingTypeElementTypeVariableNames(Binding binding) {
        ContributionBinding contributionBinding;
        if (binding instanceof ContributionBinding && !(contributionBinding = (ContributionBinding)binding).bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) && !contributionBinding.requiresModuleInstance()) {
            return ImmutableList.of();
        }
        List<? extends TypeParameterElement> typeParameters = binding.bindingTypeElement().get().getTypeParameters();
        return typeParameters.stream().map(TypeVariableName::get).collect(Util.toImmutableList());
    }

    static String simpleVariableName(TypeElement typeElement) {
        String candidateName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, typeElement.getSimpleName().toString());
        String variableName = SourceFiles.protectAgainstKeywords(candidateName);
        Verify.verify((boolean)SourceVersion.isName(variableName), (String)"'%s' was expected to be a valid variable name", (Object[])new Object[0]);
        return variableName;
    }

    private static String protectAgainstKeywords(String candidateName) {
        switch (candidateName) {
            case "package": {
                return "pkg";
            }
            case "boolean": {
                return "b";
            }
            case "double": {
                return "d";
            }
            case "byte": {
                return "b";
            }
            case "int": {
                return "i";
            }
            case "short": {
                return "s";
            }
            case "char": {
                return "c";
            }
            case "void": {
                return "v";
            }
            case "class": {
                return "clazz";
            }
            case "float": {
                return "f";
            }
            case "long": {
                return "l";
            }
        }
        return SourceVersion.isKeyword(candidateName) ? candidateName + '_' : candidateName;
    }

    private SourceFiles() {
    }
}

