/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class Util {
    static boolean componentCanMakeNewInstances(TypeElement typeElement) {
        switch (typeElement.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                throw new AssertionError((Object)("TypeElement cannot have kind: " + (Object)((Object)typeElement.getKind())));
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (Util.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR) || !((ExecutableElement)element).getParameters().isEmpty() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresEnclosingInstance(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return !typeElement.getModifiers().contains((Object)Modifier.STATIC);
            }
            case ANONYMOUS: 
            case LOCAL: {
                return true;
            }
        }
        throw new AssertionError((Object)("TypeElement cannot have nesting kind: " + (Object)((Object)typeElement.getNestingKind())));
    }

    static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf);
    }

    static <K, V> V reentrantComputeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V value = map.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            map.put(key, value);
        }
        return value;
    }

    private Util() {
    }
}

