package dagger.internal.codegen;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.SetFactory;
import dagger.internal.SingleCheck;
import dagger.spi.BindingGraphPlugin;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Provider;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class DaggerComponentProcessor_ProcessorComponent
    implements ComponentProcessor.ProcessorComponent {
  private ProcessingEnvironmentModule processingEnvironmentModule;

  private ProcessingEnvironmentModule_DaggerElementsFactory daggerElementsProvider;

  private ProcessingEnvironmentModule_TypesFactory typesProvider;

  private DaggerTypes_Factory daggerTypesProvider;

  private ProcessingEnvironmentModule_MessagerFactory messagerProvider;

  private Provider<CompilerOptions> compilerOptionsProvider;

  private InjectValidator_Factory injectValidatorProvider;

  private KeyFactory_Factory keyFactoryProvider;

  private DependencyRequestFactory_Factory dependencyRequestFactoryProvider;

  private BindingFactory_Factory bindingFactoryProvider;

  private Provider<InjectBindingRegistryImpl> injectBindingRegistryImplProvider;

  private Provider<Filer> filerProvider;

  private ProvidesMethodValidator_Factory providesMethodValidatorProvider;

  private ProducesMethodValidator_Factory producesMethodValidatorProvider;

  private BindsMethodValidator_Factory bindsMethodValidatorProvider;

  private MultibindsMethodValidator_Factory multibindsMethodValidatorProvider;

  private BindsOptionalOfMethodValidator_Factory bindsOptionalOfMethodValidatorProvider;

  private Provider<Set<BindingMethodValidator>> setOfBindingMethodValidatorProvider;

  private BindingMethodValidatorsModule_IndexValidatorsFactory indexValidatorsProvider;

  private AnyBindingMethodValidator_Factory anyBindingMethodValidatorProvider;

  private MethodSignatureFormatter_Factory methodSignatureFormatterProvider;

  private Provider<ModuleValidator> moduleValidatorProvider;

  private Provider<IncorrectlyInstalledBindsMethodsValidator>
      incorrectlyInstalledBindsMethodsValidatorProvider;

  private DependencyRequestFormatter_Factory dependencyRequestFormatterProvider;

  private BindingCycleValidation_Factory bindingCycleValidationProvider;

  private DependsOnProductionExecutorValidator_Factory dependsOnProductionExecutorValidatorProvider;

  private BindingDeclarationFormatter_Factory bindingDeclarationFormatterProvider;

  private DuplicateBindingsValidation_Factory duplicateBindingsValidationProvider;

  private IncompatiblyScopedBindingsValidation_Factory incompatiblyScopedBindingsValidationProvider;

  private InjectBindingValidation_Factory injectBindingValidationProvider;

  private MapMultibindingValidation_Factory mapMultibindingValidationProvider;

  private MembersInjectionBindingValidation_Factory membersInjectionBindingValidationProvider;

  private MissingBindingValidation_Factory missingBindingValidationProvider;

  private NonNullableRequestForNullableBindingValidation_Factory
      nonNullableRequestForNullableBindingValidationProvider;

  private SubcomponentFactoryMethodValidation_Factory subcomponentFactoryMethodValidationProvider;

  private Provider<Set<BindingGraphPlugin>> validationSetOfBindingGraphPluginProvider;

  private ProcessingEnvironmentModule_ProcessingOptionsFactory processingOptionsProvider;

  private DiagnosticReporterFactory_Factory diagnosticReporterFactoryProvider;

  private Provider<BindingGraphPlugins> validationPluginsProvider;

  private Provider<Optional<ImmutableSet<BindingGraphPlugin>>> testingPluginsProvider;

  private Provider<BindingGraphPlugins> spiPluginsProvider;

  private DaggerComponentProcessor_ProcessorComponent(Builder builder) {
    initialize(builder);
  }

  public static ComponentProcessor.ProcessorComponent.Builder builder() {
    return new Builder();
  }

  private FactoryGenerator getFactoryGenerator() {
    return new FactoryGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        compilerOptionsProvider.get());
  }

  private MembersInjectorGenerator getMembersInjectorGenerator() {
    return new MembersInjectorGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private MapKeyValidator getMapKeyValidator() {
    return new MapKeyValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private AnnotationCreatorGenerator getAnnotationCreatorGenerator() {
    return new AnnotationCreatorGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private UnwrappedMapKeyGenerator getUnwrappedMapKeyGenerator() {
    return new UnwrappedMapKeyGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private MapKeyProcessingStep getMapKeyProcessingStep() {
    return new MapKeyProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getMapKeyValidator(),
        getAnnotationCreatorGenerator(),
        getUnwrappedMapKeyGenerator());
  }

  private ForReleasableReferencesValidator getForReleasableReferencesValidator() {
    return new ForReleasableReferencesValidator(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule));
  }

  private CanReleaseReferencesProcessingStep getCanReleaseReferencesProcessingStep() {
    return new CanReleaseReferencesProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        new CanReleaseReferencesValidator(),
        getAnnotationCreatorGenerator());
  }

  private InjectProcessingStep getInjectProcessingStep() {
    return new InjectProcessingStep(injectBindingRegistryImplProvider.get());
  }

  private MonitoringModuleGenerator getMonitoringModuleGenerator() {
    return new MonitoringModuleGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private MonitoringModuleProcessingStep getMonitoringModuleProcessingStep() {
    return new MonitoringModuleProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getMonitoringModuleGenerator());
  }

  private ProductionExecutorModuleGenerator getProductionExecutorModuleGenerator() {
    return new ProductionExecutorModuleGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private ProductionExecutorModuleProcessingStep getProductionExecutorModuleProcessingStep() {
    return new ProductionExecutorModuleProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getProductionExecutorModuleGenerator());
  }

  private MultibindingAnnotationsProcessingStep getMultibindingAnnotationsProcessingStep() {
    return new MultibindingAnnotationsProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule));
  }

  private BindsInstanceProcessingStep getBindsInstanceProcessingStep() {
    return new BindsInstanceProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule));
  }

  private DaggerTypes getDaggerTypes() {
    return new DaggerTypes(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private KeyFactory getKeyFactory() {
    return new KeyFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private DependencyRequestFactory getDependencyRequestFactory() {
    return new DependencyRequestFactory(getKeyFactory(), getDaggerTypes());
  }

  private BindingFactory getBindingFactory() {
    return new BindingFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getKeyFactory(),
        getDependencyRequestFactory());
  }

  private ProducerFactoryGenerator getProducerFactoryGenerator() {
    return new ProducerFactoryGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        compilerOptionsProvider.get(),
        getKeyFactory());
  }

  private InaccessibleMapKeyProxyGenerator getInaccessibleMapKeyProxyGenerator() {
    return new InaccessibleMapKeyProxyGenerator(
        filerProvider.get(),
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private DelegateDeclaration.Factory getFactory() {
    return new DelegateDeclaration.Factory(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getKeyFactory(),
        getDependencyRequestFactory());
  }

  private ModuleProcessingStep getModuleProcessingStep() {
    return new ModuleProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        moduleValidatorProvider.get(),
        getBindingFactory(),
        getFactoryGenerator(),
        getProducerFactoryGenerator(),
        getInaccessibleMapKeyProxyGenerator(),
        getFactory());
  }

  private BuilderValidator getBuilderValidator() {
    return new BuilderValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private MethodSignatureFormatter getMethodSignatureFormatter() {
    return new MethodSignatureFormatter(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private ComponentValidator getComponentValidator() {
    return new ComponentValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        moduleValidatorProvider.get(),
        getBuilderValidator(),
        getMethodSignatureFormatter(),
        getDependencyRequestFactory());
  }

  private ComponentHierarchyValidator getComponentHierarchyValidator() {
    return new ComponentHierarchyValidator(compilerOptionsProvider.get());
  }

  private ComponentDescriptorValidator getComponentDescriptorValidator() {
    return new ComponentDescriptorValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        compilerOptionsProvider.get(),
        getMethodSignatureFormatter(),
        getComponentHierarchyValidator());
  }

  private MultibindingDeclaration.Factory getFactory4() {
    return new MultibindingDeclaration.Factory(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getKeyFactory());
  }

  private SubcomponentDeclaration.Factory getFactory5() {
    return new SubcomponentDeclaration.Factory(getKeyFactory());
  }

  private OptionalBindingDeclaration.Factory getFactory6() {
    return new OptionalBindingDeclaration.Factory(getKeyFactory());
  }

  private ModuleDescriptor.Factory getFactory3() {
    return new ModuleDescriptor.Factory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getBindingFactory(),
        getFactory4(),
        getFactory(),
        getFactory5(),
        getFactory6());
  }

  private ComponentDescriptor.Factory getFactory2() {
    return new ComponentDescriptor.Factory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getDependencyRequestFactory(),
        getFactory3(),
        compilerOptionsProvider.get());
  }

  private BindingGraphFactory getBindingGraphFactory() {
    return new BindingGraphFactory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        injectBindingRegistryImplProvider.get(),
        getKeyFactory(),
        getBindingFactory(),
        incorrectlyInstalledBindsMethodsValidatorProvider.get(),
        compilerOptionsProvider.get());
  }

  private ComponentGenerator getComponentGenerator() {
    return new ComponentGenerator(
        filerProvider.get(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        getDaggerTypes(),
        getKeyFactory(),
        compilerOptionsProvider.get(),
        getBindingGraphFactory());
  }

  private BindingDeclarationFormatter getBindingDeclarationFormatter() {
    return new BindingDeclarationFormatter(getMethodSignatureFormatter());
  }

  private BindingGraphConverter getBindingGraphConverter() {
    return new BindingGraphConverter(
        getBindingDeclarationFormatter(), compilerOptionsProvider.get());
  }

  private ComponentProcessingStep getComponentProcessingStep() {
    return new ComponentProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getComponentValidator(),
        getBuilderValidator(),
        getComponentDescriptorValidator(),
        getFactory2(),
        getBindingGraphFactory(),
        getComponentGenerator(),
        getBindingGraphConverter(),
        validationPluginsProvider.get(),
        spiPluginsProvider.get(),
        compilerOptionsProvider.get());
  }

  private ComponentHjarProcessingStep getComponentHjarProcessingStep() {
    return new ComponentHjarProcessingStep(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        filerProvider.get(),
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getComponentValidator(),
        getFactory2());
  }

  private ProvidesMethodValidator getProvidesMethodValidator() {
    return new ProvidesMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private ProducesMethodValidator getProducesMethodValidator() {
    return new ProducesMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private BindsMethodValidator getBindsMethodValidator() {
    return new BindsMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private MultibindsMethodValidator getMultibindsMethodValidator() {
    return new MultibindsMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private BindsOptionalOfMethodValidator getBindsOptionalOfMethodValidator() {
    return new BindsOptionalOfMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private Set<BindingMethodValidator> getSetOfBindingMethodValidator() {
    return ImmutableSet.<BindingMethodValidator>of(
        getProvidesMethodValidator(),
        getProducesMethodValidator(),
        getBindsMethodValidator(),
        getMultibindsMethodValidator(),
        getBindsOptionalOfMethodValidator());
  }

  private ImmutableMap<Class<? extends Annotation>, BindingMethodValidator>
      getImmutableMapOfClassOfAndBindingMethodValidator() {
    return BindingMethodValidatorsModule_IndexValidatorsFactory.proxyIndexValidators(
        getSetOfBindingMethodValidator());
  }

  private AnyBindingMethodValidator getAnyBindingMethodValidator() {
    return new AnyBindingMethodValidator(getImmutableMapOfClassOfAndBindingMethodValidator());
  }

  private BindingMethodProcessingStep getBindingMethodProcessingStep() {
    return new BindingMethodProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getAnyBindingMethodValidator());
  }

  private ImmutableList<BasicAnnotationProcessor.ProcessingStep>
      getImmutableListOfProcessingStep() {
    return ComponentProcessor_ProcessingStepsModule_ProcessingStepsFactory.proxyProcessingSteps(
        getMapKeyProcessingStep(),
        getForReleasableReferencesValidator(),
        getCanReleaseReferencesProcessingStep(),
        getInjectProcessingStep(),
        getMonitoringModuleProcessingStep(),
        getProductionExecutorModuleProcessingStep(),
        getMultibindingAnnotationsProcessingStep(),
        getBindsInstanceProcessingStep(),
        getModuleProcessingStep(),
        getComponentProcessingStep(),
        getComponentHjarProcessingStep(),
        getBindingMethodProcessingStep(),
        compilerOptionsProvider.get());
  }

  @SuppressWarnings("unchecked")
  private void initialize(final Builder builder) {
    this.daggerElementsProvider =
        ProcessingEnvironmentModule_DaggerElementsFactory.create(
            builder.processingEnvironmentModule);
    this.typesProvider =
        ProcessingEnvironmentModule_TypesFactory.create(builder.processingEnvironmentModule);
    this.daggerTypesProvider = DaggerTypes_Factory.create(typesProvider, daggerElementsProvider);
    this.messagerProvider =
        ProcessingEnvironmentModule_MessagerFactory.create(builder.processingEnvironmentModule);
    this.compilerOptionsProvider =
        SingleCheck.provider(
            ProcessingEnvironmentModule_CompilerOptionsFactory.create(
                builder.processingEnvironmentModule, daggerElementsProvider));
    this.injectValidatorProvider =
        InjectValidator_Factory.create(
            typesProvider, daggerElementsProvider, compilerOptionsProvider);
    this.keyFactoryProvider =
        KeyFactory_Factory.create(daggerTypesProvider, (Provider) daggerElementsProvider);
    this.dependencyRequestFactoryProvider =
        DependencyRequestFactory_Factory.create(keyFactoryProvider, daggerTypesProvider);
    this.bindingFactoryProvider =
        BindingFactory_Factory.create(
            daggerTypesProvider,
            daggerElementsProvider,
            keyFactoryProvider,
            dependencyRequestFactoryProvider);
    this.injectBindingRegistryImplProvider =
        DoubleCheck.provider(
            InjectBindingRegistryImpl_Factory.create(
                (Provider) daggerElementsProvider,
                daggerTypesProvider,
                messagerProvider,
                injectValidatorProvider,
                keyFactoryProvider,
                bindingFactoryProvider,
                compilerOptionsProvider));
    this.filerProvider =
        SingleCheck.provider(
            ProcessingEnvironmentModule_FilerFactory.create(
                builder.processingEnvironmentModule, compilerOptionsProvider, messagerProvider));
    this.processingEnvironmentModule = builder.processingEnvironmentModule;
    this.providesMethodValidatorProvider =
        ProvidesMethodValidator_Factory.create(daggerElementsProvider, typesProvider);
    this.producesMethodValidatorProvider =
        ProducesMethodValidator_Factory.create(daggerElementsProvider, typesProvider);
    this.bindsMethodValidatorProvider =
        BindsMethodValidator_Factory.create(daggerElementsProvider, typesProvider);
    this.multibindsMethodValidatorProvider =
        MultibindsMethodValidator_Factory.create(daggerElementsProvider, typesProvider);
    this.bindsOptionalOfMethodValidatorProvider =
        BindsOptionalOfMethodValidator_Factory.create(daggerElementsProvider, typesProvider);
    this.setOfBindingMethodValidatorProvider =
        SetFactory.<BindingMethodValidator>builder(5, 0)
            .addProvider((Provider) providesMethodValidatorProvider)
            .addProvider((Provider) producesMethodValidatorProvider)
            .addProvider((Provider) bindsMethodValidatorProvider)
            .addProvider((Provider) multibindsMethodValidatorProvider)
            .addProvider((Provider) bindsOptionalOfMethodValidatorProvider)
            .build();
    this.indexValidatorsProvider =
        BindingMethodValidatorsModule_IndexValidatorsFactory.create(
            setOfBindingMethodValidatorProvider);
    this.anyBindingMethodValidatorProvider =
        AnyBindingMethodValidator_Factory.create(indexValidatorsProvider);
    this.methodSignatureFormatterProvider = MethodSignatureFormatter_Factory.create(typesProvider);
    this.moduleValidatorProvider =
        DoubleCheck.provider(
            ModuleValidator_Factory.create(
                typesProvider,
                daggerElementsProvider,
                anyBindingMethodValidatorProvider,
                methodSignatureFormatterProvider));
    this.incorrectlyInstalledBindsMethodsValidatorProvider =
        DoubleCheck.provider(
            IncorrectlyInstalledBindsMethodsValidator_Factory.create(compilerOptionsProvider));
    this.dependencyRequestFormatterProvider =
        DependencyRequestFormatter_Factory.create(daggerTypesProvider);
    this.bindingCycleValidationProvider =
        BindingCycleValidation_Factory.create(dependencyRequestFormatterProvider);
    this.dependsOnProductionExecutorValidatorProvider =
        DependsOnProductionExecutorValidator_Factory.create(
            compilerOptionsProvider, keyFactoryProvider);
    this.bindingDeclarationFormatterProvider =
        BindingDeclarationFormatter_Factory.create(methodSignatureFormatterProvider);
    this.duplicateBindingsValidationProvider =
        DuplicateBindingsValidation_Factory.create(bindingDeclarationFormatterProvider);
    this.incompatiblyScopedBindingsValidationProvider =
        IncompatiblyScopedBindingsValidation_Factory.create(methodSignatureFormatterProvider);
    this.injectBindingValidationProvider =
        InjectBindingValidation_Factory.create(injectValidatorProvider);
    this.mapMultibindingValidationProvider =
        MapMultibindingValidation_Factory.create(bindingDeclarationFormatterProvider);
    this.membersInjectionBindingValidationProvider =
        MembersInjectionBindingValidation_Factory.create(daggerTypesProvider);
    this.missingBindingValidationProvider =
        MissingBindingValidation_Factory.create(
            daggerTypesProvider,
            daggerElementsProvider,
            (Provider) injectBindingRegistryImplProvider);
    this.nonNullableRequestForNullableBindingValidationProvider =
        NonNullableRequestForNullableBindingValidation_Factory.create(compilerOptionsProvider);
    this.subcomponentFactoryMethodValidationProvider =
        SubcomponentFactoryMethodValidation_Factory.create(daggerTypesProvider);
    this.validationSetOfBindingGraphPluginProvider =
        SetFactory.<BindingGraphPlugin>builder(12, 0)
            .addProvider((Provider) bindingCycleValidationProvider)
            .addProvider((Provider) dependsOnProductionExecutorValidatorProvider)
            .addProvider((Provider) duplicateBindingsValidationProvider)
            .addProvider((Provider) incompatiblyScopedBindingsValidationProvider)
            .addProvider((Provider) injectBindingValidationProvider)
            .addProvider((Provider) mapMultibindingValidationProvider)
            .addProvider((Provider) membersInjectionBindingValidationProvider)
            .addProvider((Provider) missingBindingValidationProvider)
            .addProvider((Provider) nonNullableRequestForNullableBindingValidationProvider)
            .addProvider((Provider) ProvisionDependencyOnProducerBindingValidation_Factory.create())
            .addProvider((Provider) subcomponentFactoryMethodValidationProvider)
            .addProvider((Provider) incorrectlyInstalledBindsMethodsValidatorProvider)
            .build();
    this.processingOptionsProvider =
        ProcessingEnvironmentModule_ProcessingOptionsFactory.create(
            builder.processingEnvironmentModule);
    this.diagnosticReporterFactoryProvider =
        DiagnosticReporterFactory_Factory.create(
            messagerProvider, dependencyRequestFormatterProvider);
    this.validationPluginsProvider =
        DoubleCheck.provider(
            BindingGraphPluginsModule_ValidationPluginsFactory.create(
                validationSetOfBindingGraphPluginProvider,
                filerProvider,
                typesProvider,
                (Provider) daggerElementsProvider,
                processingOptionsProvider,
                diagnosticReporterFactoryProvider));
    this.testingPluginsProvider = InstanceFactory.create(builder.testingPlugins);
    this.spiPluginsProvider =
        DoubleCheck.provider(
            BindingGraphPluginsModule_SpiPluginsFactory.create(
                testingPluginsProvider,
                filerProvider,
                typesProvider,
                (Provider) daggerElementsProvider,
                processingOptionsProvider,
                diagnosticReporterFactoryProvider));
  }

  @Override
  public void inject(ComponentProcessor processor) {
    injectComponentProcessor(processor);
  }

  @CanIgnoreReturnValue
  private ComponentProcessor injectComponentProcessor(ComponentProcessor instance) {
    ComponentProcessor_MembersInjector.injectInjectBindingRegistry(
        instance, injectBindingRegistryImplProvider.get());
    ComponentProcessor_MembersInjector.injectFactoryGenerator(instance, getFactoryGenerator());
    ComponentProcessor_MembersInjector.injectMembersInjectorGenerator(
        instance, getMembersInjectorGenerator());
    ComponentProcessor_MembersInjector.injectProcessingSteps(
        instance, getImmutableListOfProcessingStep());
    ComponentProcessor_MembersInjector.injectSpiPlugins(instance, spiPluginsProvider.get());
    ComponentProcessor_MembersInjector.injectValidationPlugins(
        instance, validationPluginsProvider.get());
    return instance;
  }

  private static final class Builder implements ComponentProcessor.ProcessorComponent.Builder {
    private ProcessingEnvironmentModule processingEnvironmentModule;

    private Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;

    @Override
    public ComponentProcessor.ProcessorComponent build() {
      if (processingEnvironmentModule == null) {
        throw new IllegalStateException(
            ProcessingEnvironmentModule.class.getCanonicalName() + " must be set");
      }
      if (testingPlugins == null) {
        throw new IllegalStateException(Optional.class.getCanonicalName() + " must be set");
      }
      return new DaggerComponentProcessor_ProcessorComponent(this);
    }

    @Override
    public Builder processingEnvironmentModule(ProcessingEnvironmentModule module) {
      this.processingEnvironmentModule = Preconditions.checkNotNull(module);
      return this;
    }

    @Override
    public Builder testingPlugins(Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins) {
      this.testingPlugins = Preconditions.checkNotNull(testingPlugins);
      return this;
    }
  }
}
