/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.hilt.processor.internal.root.ir.AggregatedDepsIr;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

@AutoValue
public abstract class AggregatedDepsMetadata {
    private static final String AGGREGATED_DEPS_PACKAGE = "hilt_aggregated_deps";

    public abstract TypeElement aggregatingElement();

    public abstract Optional<TypeElement> testElement();

    public abstract ImmutableSet<TypeElement> componentElements();

    abstract DependencyType dependencyType();

    public abstract TypeElement dependency();

    public abstract ImmutableSet<TypeElement> replacedDependencies();

    public boolean isModule() {
        return this.dependencyType() == DependencyType.MODULE;
    }

    public static ImmutableSet<AggregatedDepsMetadata> from(Elements elements) {
        return AggregatedDepsMetadata.from(AggregatedElements.from(AGGREGATED_DEPS_PACKAGE, ClassNames.AGGREGATED_DEPS, elements), elements);
    }

    public static ImmutableSet<AggregatedDepsMetadata> from(ImmutableSet<TypeElement> aggregatedElements, Elements elements) {
        return (ImmutableSet)aggregatedElements.stream().map(aggregatedElement -> AggregatedDepsMetadata.create(aggregatedElement, elements)).collect(DaggerStreams.toImmutableSet());
    }

    public static AggregatedDepsIr toIr(AggregatedDepsMetadata metadata) {
        return new AggregatedDepsIr(ClassName.get((TypeElement)metadata.aggregatingElement()), metadata.componentElements().stream().map(ClassName::get).map(ClassName::canonicalName).collect(Collectors.toList()), metadata.testElement().map(ClassName::get).map(ClassName::canonicalName).orElse(null), metadata.replacedDependencies().stream().map(ClassName::get).map(ClassName::canonicalName).collect(Collectors.toList()), metadata.dependencyType() == DependencyType.MODULE ? ClassName.get((TypeElement)metadata.dependency()).canonicalName() : null, metadata.dependencyType() == DependencyType.ENTRY_POINT ? ClassName.get((TypeElement)metadata.dependency()).canonicalName() : null, metadata.dependencyType() == DependencyType.COMPONENT_ENTRY_POINT ? ClassName.get((TypeElement)metadata.dependency()).canonicalName() : null);
    }

    private static AggregatedDepsMetadata create(TypeElement element, Elements elements) {
        AnnotationMirror annotationMirror = Processors.getAnnotationMirror((Element)element, ClassNames.AGGREGATED_DEPS);
        ImmutableMap<String, AnnotationValue> values = Processors.getAnnotationValues(elements, annotationMirror);
        return new AutoValue_AggregatedDepsMetadata(element, AggregatedDepsMetadata.getTestElement((AnnotationValue)values.get((Object)"test"), elements), AggregatedDepsMetadata.getComponents((AnnotationValue)values.get((Object)"components"), elements), AggregatedDepsMetadata.getDependencyType((AnnotationValue)values.get((Object)"modules"), (AnnotationValue)values.get((Object)"entryPoints"), (AnnotationValue)values.get((Object)"componentEntryPoints")), AggregatedDepsMetadata.getDependency((AnnotationValue)values.get((Object)"modules"), (AnnotationValue)values.get((Object)"entryPoints"), (AnnotationValue)values.get((Object)"componentEntryPoints"), elements), AggregatedDepsMetadata.getReplacedDependencies((AnnotationValue)values.get((Object)"replaces"), elements));
    }

    private static Optional<TypeElement> getTestElement(AnnotationValue testValue, Elements elements) {
        Preconditions.checkNotNull((Object)testValue);
        String test = AnnotationValues.getString(testValue);
        return test.isEmpty() ? Optional.empty() : Optional.of(elements.getTypeElement(test));
    }

    private static ImmutableSet<TypeElement> getComponents(AnnotationValue componentsValue, Elements elements) {
        Preconditions.checkNotNull((Object)componentsValue);
        ImmutableSet componentNames = (ImmutableSet)AnnotationValues.getAnnotationValues(componentsValue).stream().map(AnnotationValues::getString).map(componentName -> componentName.contentEquals("dagger.hilt.android.components.ApplicationComponent") ? ClassNames.SINGLETON_COMPONENT.canonicalName() : componentName).map(elements::getTypeElement).collect(DaggerStreams.toImmutableSet());
        Preconditions.checkState((!componentNames.isEmpty() ? 1 : 0) != 0);
        return componentNames;
    }

    private static DependencyType getDependencyType(AnnotationValue modulesValue, AnnotationValue entryPointsValue, AnnotationValue componentEntryPointsValue) {
        Preconditions.checkNotNull((Object)modulesValue);
        Preconditions.checkNotNull((Object)entryPointsValue);
        Preconditions.checkNotNull((Object)componentEntryPointsValue);
        ImmutableSet.Builder dependencyTypes = ImmutableSet.builder();
        if (!AnnotationValues.getAnnotationValues(modulesValue).isEmpty()) {
            dependencyTypes.add((Object)DependencyType.MODULE);
        }
        if (!AnnotationValues.getAnnotationValues(entryPointsValue).isEmpty()) {
            dependencyTypes.add((Object)DependencyType.ENTRY_POINT);
        }
        if (!AnnotationValues.getAnnotationValues(componentEntryPointsValue).isEmpty()) {
            dependencyTypes.add((Object)DependencyType.COMPONENT_ENTRY_POINT);
        }
        return (DependencyType)((Object)Iterables.getOnlyElement((Iterable)dependencyTypes.build()));
    }

    private static TypeElement getDependency(AnnotationValue modulesValue, AnnotationValue entryPointsValue, AnnotationValue componentEntryPointsValue, Elements elements) {
        Preconditions.checkNotNull((Object)modulesValue);
        Preconditions.checkNotNull((Object)entryPointsValue);
        Preconditions.checkNotNull((Object)componentEntryPointsValue);
        return elements.getTypeElement(AnnotationValues.getString((AnnotationValue)Iterables.getOnlyElement((Iterable)ImmutableSet.builder().addAll(AnnotationValues.getAnnotationValues(modulesValue)).addAll(AnnotationValues.getAnnotationValues(entryPointsValue)).addAll(AnnotationValues.getAnnotationValues(componentEntryPointsValue)).build())));
    }

    private static ImmutableSet<TypeElement> getReplacedDependencies(AnnotationValue replacedDependenciesValue, Elements elements) {
        return replacedDependenciesValue == null ? ImmutableSet.of() : (ImmutableSet)AnnotationValues.getAnnotationValues(replacedDependenciesValue).stream().map(AnnotationValues::getString).map(elements::getTypeElement).map(replacedDep -> AggregatedDepsMetadata.getPublicDependency(replacedDep, elements)).collect(DaggerStreams.toImmutableSet());
    }

    private static TypeElement getPublicDependency(TypeElement dependency, Elements elements) {
        return PkgPrivateMetadata.of(elements, dependency, ClassNames.MODULE).map(metadata -> elements.getTypeElement(metadata.generatedClassName().toString())).orElse(dependency);
    }

    static enum DependencyType {
        MODULE,
        ENTRY_POINT,
        COMPONENT_ENTRY_POINT;

    }
}

