/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aliasof;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataGenerator;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoService(value={Processor.class})
public final class AliasOfProcessor
extends BaseProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.ALIAS_OF.toString());
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        ProcessorErrors.checkState(Processors.hasAnnotation(element, ClassNames.SCOPE), element, "%s should only be used on scopes. However, it was found annotating %s", annotation, element);
        AnnotationMirror annotationMirror = Processors.getAnnotationMirror(element, ClassNames.ALIAS_OF);
        ImmutableList<TypeElement> defineComponentScopes = Processors.getAnnotationClassValues(this.getElementUtils(), annotationMirror, "value");
        ProcessorErrors.checkState(defineComponentScopes.size() >= 1, element, "@AliasOf annotation %s must declare at least one scope to alias.", annotationMirror);
        new AliasOfPropagatedDataGenerator(this.getProcessingEnv(), MoreElements.asType(element), defineComponentScopes).generate();
    }
}

