/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.kotlin;

import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.kotlin.KotlinMetadata;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtil;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class KotlinMetadataFactory {
    private final Map<TypeElement, KotlinMetadata> metadataCache = new HashMap<TypeElement, KotlinMetadata>();

    @Inject
    KotlinMetadataFactory() {
    }

    public KotlinMetadata create(Element element) {
        TypeElement enclosingElement = KotlinMetadataUtil.closestEnclosingTypeElement(element);
        if (!MoreElements.isAnnotationPresent((Element)enclosingElement, ClassNames.KOTLIN_METADATA.canonicalName())) {
            throw new IllegalStateException("Missing @Metadata for: " + enclosingElement);
        }
        return this.metadataCache.computeIfAbsent(enclosingElement, KotlinMetadata::from);
    }
}

