/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.postgresql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgreSQLDbSupport
implements DbSupport {
    private static final String DEFAULT_SCHEMA_PATTERN = "public";
    private static final String[] TABLE_EXISTS_TABLE_TYPES = new String[]{"TABLE"};
    private final JdbcTemplate jdbcTemplate;

    public PostgreSQLDbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/postgresql/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "current_user";
    }

    @Override
    public String getCurrentSchema() {
        return (String)this.jdbcTemplate.queryForObject("SELECT current_schema()", String.class);
    }

    @Override
    public boolean isSchemaEmpty(String schema) {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", (Object[])new String[]{schema});
        return objectCount == 0;
    }

    @Override
    public boolean tableExists(final String schema, final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, schema.toLowerCase(), table.toLowerCase(), TABLE_EXISTS_TABLE_TYPES);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String schema, String table) {
        this.jdbcTemplate.execute("select * from " + schema + "." + table + " for update");
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new PostgreSQLSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(String schema) {
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.addAll(this.generateDropStatementsForTables(schema));
        allDropStatements.addAll(this.generateDropStatementsForSequences(schema));
        allDropStatements.addAll(this.generateDropStatementsForRoutines(schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(lineNumber, dropStatement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> generateDropStatementsForTables(String schema) {
        List tableNames = this.jdbcTemplate.queryForList("SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", (Object[])new String[]{schema});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : tableNames) {
            String tableName = (String)row.get("table_name");
            statements.add("DROP TABLE \"" + schema + "\".\"" + tableName + "\" CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForSequences(String schema) {
        List sequenceNames = this.jdbcTemplate.queryForList("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema=?", (Object[])new String[]{schema});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : sequenceNames) {
            String sequenceName = (String)row.get("sequence_name");
            statements.add("DROP SEQUENCE IF EXISTS \"" + schema + "\".\"" + sequenceName + "\"");
        }
        return statements;
    }

    private List<String> generateDropStatementsForRoutines(String schema) {
        List rows = this.jdbcTemplate.queryForList("SELECT proname, oidvectortypes(proargtypes) AS args FROM pg_proc INNER JOIN pg_namespace ns ON (pg_proc.pronamespace = ns.oid) WHERE ns.nspname = ?", (Object[])new String[]{schema});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : rows) {
            statements.add("DROP FUNCTION \"" + schema + "\".\"" + (String)row.get("proname") + "\"(" + (String)row.get("args") + ")");
        }
        return statements;
    }
}

