/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.sqlserver;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class SQLServerDbSupport
implements DbSupport {
    private final JdbcTemplate jdbcTemplate;

    public SQLServerDbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/sqlserver/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "SUSER_NAME()";
    }

    @Override
    public String getCurrentSchema() {
        return (String)this.jdbcTemplate.queryForObject("SELECT SCHEMA_NAME()", String.class);
    }

    @Override
    public boolean isSchemaEmpty(String schema) {
        int objectCount = this.jdbcTemplate.queryForInt("Select count(*) FROM ( Select TABLE_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from information_schema.TABLES Union Select TABLE_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from information_schema.VIEWS Union Select CONSTRAINT_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from information_schema.TABLE_CONSTRAINTS Union Select ROUTINE_NAME as OBJECT_NAME, ROUTINE_SCHEMA as OBJECT_SCHEMA from information_schema.ROUTINES ) R where OBJECT_SCHEMA = ?", (Object[])new String[]{schema});
        return objectCount == 0;
    }

    @Override
    public boolean tableExists(final String schema, final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, schema, table, null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String schema, String table) {
        this.jdbcTemplate.execute("select * from " + schema + "." + table + " WITH (TABLOCKX)");
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new SQLServerSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(String schema) {
        List<String> statements = this.cleanForeignKeys(schema);
        statements.addAll(this.cleanRoutines(schema));
        statements.addAll(this.cleanViews(schema));
        statements.addAll(this.cleanTables(schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String statement : statements) {
            sqlStatements.add(new SqlStatement(lineNumber, statement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> cleanTables(String schema) {
        List tableNames = this.jdbcTemplate.queryForList("SELECT table_name FROM information_schema.tables WHERE table_type='BASE TABLE' and table_schema=?", (Object[])new String[]{schema}, String.class);
        ArrayList<String> statements = new ArrayList<String>();
        for (String tableName : tableNames) {
            statements.add("DROP TABLE [" + schema + "].[" + tableName + "]");
        }
        return statements;
    }

    private List<String> cleanForeignKeys(String schema) {
        List constraintNames = this.jdbcTemplate.queryForList("SELECT table_name, constraint_name FROM information_schema.table_constraints WHERE constraint_type = 'FOREIGN KEY' and table_schema=?", (Object[])new String[]{schema});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : constraintNames) {
            String tableName = (String)row.get("table_name");
            String constraintName = (String)row.get("constraint_name");
            statements.add("ALTER TABLE [" + schema + "].[" + tableName + "] DROP CONSTRAINT [" + constraintName + "]");
        }
        return statements;
    }

    private List<String> cleanRoutines(String schema) {
        List routineNames = this.jdbcTemplate.queryForList("SELECT routine_name, routine_type FROM information_schema.routines WHERE routine_schema=?", (Object[])new String[]{schema});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : routineNames) {
            String routineName = (String)row.get("routine_name");
            String routineType = (String)row.get("routine_type");
            statements.add("DROP " + routineType + " [" + schema + "].[" + routineName + "]");
        }
        return statements;
    }

    private List<String> cleanViews(String schema) {
        List viewNames = this.jdbcTemplate.queryForList("SELECT table_name FROM information_schema.views WHERE table_schema=?", (Object[])new String[]{schema}, String.class);
        ArrayList<String> statements = new ArrayList<String>();
        for (String viewName : viewNames) {
            statements.add("DROP VIEW [" + schema + "].[" + viewName + "]");
        }
        return statements;
    }
}

