/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.init;

import com.googlecode.flyway.core.init.InitException;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.init.InitMigration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DbInit {
    private static final Log LOG = LogFactory.getLog(DbInit.class);
    private final MetaDataTable metaDataTable;
    private final TransactionTemplate transactionTemplate;

    public DbInit(TransactionTemplate transactionTemplate, MetaDataTable metaDataTable) {
        this.transactionTemplate = transactionTemplate;
        this.metaDataTable = metaDataTable;
    }

    public void init(SchemaVersion version, String description) throws InitException {
        if (this.metaDataTable.getCurrentSchemaVersion() != SchemaVersion.EMPTY) {
            throw new InitException("Schema already initialized. Current Version: " + this.metaDataTable.getCurrentSchemaVersion());
        }
        this.metaDataTable.createIfNotExists();
        InitMigration initialMigration = new InitMigration(version, description);
        final MetaDataTableRow metaDataTableRow = new MetaDataTableRow(initialMigration);
        metaDataTableRow.update(0, MigrationState.SUCCESS);
        try {
            this.transactionTemplate.execute(new TransactionCallback(){

                public Void doInTransaction(TransactionStatus status) {
                    DbInit.this.metaDataTable.insert(metaDataTableRow);
                    return null;
                }
            });
        }
        catch (TransactionException e) {
            throw new InitException("Unable to initialize schema", e);
        }
        LOG.info((Object)("Schema initialized with version: " + metaDataTableRow.getVersion()));
    }
}

