/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderReplacer {
    public static final PlaceholderReplacer NO_PLACEHOLDERS = new PlaceholderReplacer(new HashMap<String, String>(), "", "");
    private final Map<String, String> placeholders;
    private final String placeholderPrefix;
    private final String placeholderSuffix;

    public PlaceholderReplacer(Map<String, String> placeholders, String placeholderPrefix, String placeholderSuffix) {
        this.placeholders = placeholders;
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    public String replacePlaceholders(String input) {
        String noPlaceholders = input;
        for (String placeholder : this.placeholders.keySet()) {
            String searchTerm = this.placeholderPrefix + placeholder + this.placeholderSuffix;
            noPlaceholders = noPlaceholders.replaceAll(Pattern.quote(searchTerm), Matcher.quoteReplacement(this.placeholders.get(placeholder)));
        }
        return noPlaceholders;
    }
}

