/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationInfoHelper;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.ResourceUtils;
import java.util.zip.CRC32;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlMigration
extends Migration {
    private final PlaceholderReplacer placeholderReplacer;
    private final String sqlScriptSource;

    public SqlMigration(Resource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding, String versionString, String scriptName) {
        this.schemaVersion = MigrationInfoHelper.extractSchemaVersion(versionString);
        this.description = MigrationInfoHelper.extractDescription(versionString);
        this.sqlScriptSource = ResourceUtils.loadResourceAsString(sqlScriptResource, encoding);
        this.checksum = this.calculateChecksum(this.sqlScriptSource);
        this.script = scriptName;
        this.placeholderReplacer = placeholderReplacer;
    }

    @Override
    public void migrate(JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        SqlScript sqlScript = dbSupport.createSqlScript(this.sqlScriptSource, this.placeholderReplacer);
        sqlScript.execute(jdbcTemplate);
    }

    private int calculateChecksum(String sql) {
        CRC32 crc32 = new CRC32();
        crc32.update(sql.getBytes());
        return (int)crc32.getValue();
    }

    @Override
    public MigrationType getMigrationType() {
        return MigrationType.SQL;
    }
}

