/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.command;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;

public class DbInit {
    private static final Log LOG = LogFactory.getLog(DbInit.class);
    private final Connection connection;
    private final MetaDataTable metaDataTable;
    private final MigrationVersion initVersion;
    private final String initDescription;

    public DbInit(Connection connection, MetaDataTable metaDataTable, MigrationVersion initVersion, String initDescription) {
        this.connection = connection;
        this.metaDataTable = metaDataTable;
        this.initVersion = initVersion;
        this.initDescription = initDescription;
    }

    public void init() {
        new TransactionTemplate(this.connection).execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                if (DbInit.this.metaDataTable.hasAppliedMigrations()) {
                    throw new FlywayException("Unable to init metadata table " + DbInit.this.metaDataTable + " as it already contains migrations");
                }
                if (DbInit.this.metaDataTable.hasInitMarker()) {
                    throw new FlywayException("Unable to init metadata table " + DbInit.this.metaDataTable + " as it has already been initialized");
                }
                if (DbInit.this.metaDataTable.hasSchemasMarker() && DbInit.this.initVersion.equals(new MigrationVersion("0"))) {
                    throw new FlywayException("Unable to init metadata table " + DbInit.this.metaDataTable + " with version 0 as this version was used for schema creation");
                }
                DbInit.this.metaDataTable.addInitMarker(DbInit.this.initVersion, DbInit.this.initDescription);
                return null;
            }
        });
        LOG.info("Schema initialized with version: " + this.initVersion);
    }
}

