/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.Table;
import com.googlecode.flyway.core.metadatatable.AppliedMigration;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableTo202FormatUpgrader;
import com.googlecode.flyway.core.metadatatable.MetaDataTableTo20FormatUpgrader;
import com.googlecode.flyway.core.metadatatable.MetaDataTableTo21FormatUpgrader;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.RowMapper;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataTableImpl
implements MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTableImpl.class);
    private boolean upgraded;
    private final DbSupport dbSupport;
    private final Table table;
    private final MigrationResolver migrationResolver;
    private final JdbcTemplate jdbcTemplate;

    public MetaDataTableImpl(DbSupport dbSupport, Table table, MigrationResolver migrationResolver) {
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.dbSupport = dbSupport;
        this.table = table;
        this.migrationResolver = migrationResolver;
    }

    private void createIfNotExists() {
        if (this.table.existsNoQuotes() || this.table.exists()) {
            if (!this.upgraded) {
                new MetaDataTableTo20FormatUpgrader(this.dbSupport, this.table, this.migrationResolver).upgrade();
                new MetaDataTableTo202FormatUpgrader(this.dbSupport, this.table).upgrade();
                new MetaDataTableTo21FormatUpgrader(this.dbSupport, this.table).upgrade();
                this.upgraded = true;
            }
            return;
        }
        LOG.info("Creating Metadata table: " + this.table);
        String source = new ClassPathResource(this.dbSupport.getScriptLocation() + "createMetaDataTable.sql").loadAsString("UTF-8");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("schema", this.table.getSchema().getName());
        placeholders.put("table", this.table.getName());
        String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
        SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
        sqlScript.execute(this.jdbcTemplate);
        LOG.debug("Metadata table " + this.table + " created.");
    }

    @Override
    public void lock() {
        this.createIfNotExists();
        this.table.lock();
    }

    @Override
    public void addAppliedMigration(AppliedMigration appliedMigration) {
        this.createIfNotExists();
        MigrationVersion version = appliedMigration.getVersion();
        try {
            int versionRank = this.calculateVersionRank(version);
            this.jdbcTemplate.update("UPDATE " + this.table + " SET " + this.dbSupport.quote("version_rank") + " = " + this.dbSupport.quote("version_rank") + " + 1 WHERE " + this.dbSupport.quote("version_rank") + " >= ?", versionRank);
            this.jdbcTemplate.update("INSERT INTO " + this.table + " (" + this.dbSupport.quote("version_rank") + "," + this.dbSupport.quote("installed_rank") + "," + this.dbSupport.quote("version") + "," + this.dbSupport.quote("description") + "," + this.dbSupport.quote("type") + "," + this.dbSupport.quote("script") + "," + this.dbSupport.quote("checksum") + "," + this.dbSupport.quote("installed_by") + "," + this.dbSupport.quote("execution_time") + "," + this.dbSupport.quote("success") + ")" + " VALUES (?, ?, ?, ?, ?, ?, ?, " + this.dbSupport.getCurrentUserFunction() + ", ?, ?)", versionRank, this.calculateInstalledRank(), version.toString(), appliedMigration.getDescription(), appliedMigration.getType().name(), appliedMigration.getScript(), appliedMigration.getChecksum(), appliedMigration.getExecutionTime(), appliedMigration.isSuccess());
            LOG.debug("MetaData table " + this.table + " successfully updated to reflect changes");
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to insert row for version '" + version + "' in metadata table " + this.table, e);
        }
    }

    private int calculateInstalledRank() throws SQLException {
        int currentMax = this.jdbcTemplate.queryForInt("SELECT MAX(" + this.dbSupport.quote("installed_rank") + ")" + " FROM " + this.table, new String[0]);
        return currentMax + 1;
    }

    private int calculateVersionRank(MigrationVersion version) throws SQLException {
        List<String> versions = this.jdbcTemplate.queryForStringList("select " + this.dbSupport.quote("version") + " from " + this.table, new String[0]);
        ArrayList<MigrationVersion> migrationVersions = new ArrayList<MigrationVersion>();
        for (String versionStr : versions) {
            migrationVersions.add(new MigrationVersion(versionStr));
        }
        Collections.sort(migrationVersions);
        for (int i = 0; i < migrationVersions.size(); ++i) {
            if (version.compareTo((MigrationVersion)migrationVersions.get(i)) >= 0) continue;
            return i + 1;
        }
        return migrationVersions.size() + 1;
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        if (!this.table.existsNoQuotes() && !this.table.exists()) {
            return new ArrayList<AppliedMigration>();
        }
        this.createIfNotExists();
        String query = "SELECT " + this.dbSupport.quote("version_rank") + "," + this.dbSupport.quote("installed_rank") + "," + this.dbSupport.quote("version") + "," + this.dbSupport.quote("description") + "," + this.dbSupport.quote("type") + "," + this.dbSupport.quote("script") + "," + this.dbSupport.quote("checksum") + "," + this.dbSupport.quote("installed_on") + "," + this.dbSupport.quote("installed_by") + "," + this.dbSupport.quote("execution_time") + "," + this.dbSupport.quote("success") + " FROM " + this.table + " ORDER BY " + this.dbSupport.quote("version_rank");
        try {
            return this.jdbcTemplate.query(query, new RowMapper<AppliedMigration>(){

                @Override
                public AppliedMigration mapRow(ResultSet rs) throws SQLException {
                    return new AppliedMigration(rs.getInt("version_rank"), rs.getInt("installed_rank"), new MigrationVersion(rs.getString("version")), rs.getString("description"), MigrationType.valueOf(rs.getString("type")), rs.getString("script"), MetaDataTableImpl.this.toInteger((Number)rs.getObject("checksum")), rs.getTimestamp("installed_on"), rs.getString("installed_by"), MetaDataTableImpl.this.toInteger((Number)rs.getObject("execution_time")), rs.getBoolean("success"));
                }
            });
        }
        catch (SQLException e) {
            throw new FlywayException("Error while retrieving the list of applied migrations from metadata table " + this.table, e);
        }
    }

    private Integer toInteger(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    @Override
    public void addInitMarker(MigrationVersion initVersion, String initDescription) {
        this.addAppliedMigration(new AppliedMigration(initVersion, initDescription, MigrationType.INIT, initDescription, null, 0, true));
    }

    @Override
    public void repair() {
        if (!this.table.existsNoQuotes() && !this.table.exists()) {
            LOG.info("Repair of metadata table " + this.table + " not necessary. No failed migration detected.");
            return;
        }
        this.createIfNotExists();
        try {
            int failedCount = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("success") + "=" + this.dbSupport.getBooleanFalse(), new String[0]);
            if (failedCount == 0) {
                LOG.info("Repair of metadata table " + this.table + " not necessary. No failed migration detected.");
                return;
            }
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check the metadata table " + this.table + " for failed migrations", e);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.jdbcTemplate.execute("DELETE FROM " + this.table + " WHERE " + this.dbSupport.quote("success") + " = " + this.dbSupport.getBooleanFalse(), new Object[0]);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to repair metadata table " + this.table, e);
        }
        stopWatch.stop();
        LOG.info("Metadata table " + this.table + " successfully repaired (execution time " + TimeFormat.format(stopWatch.getTotalTimeMillis()) + ").");
        LOG.info("Manual cleanup of the remaining effects the failed migration may still be required.");
    }

    @Override
    public void addSchemasMarker(Schema[] schemas) {
        this.createIfNotExists();
        this.addAppliedMigration(new AppliedMigration(new MigrationVersion("0"), "<< Flyway Schema Creation >>", MigrationType.SCHEMA, StringUtils.arrayToCommaDelimitedString(schemas), null, 0, true));
    }

    @Override
    public boolean hasSchemasMarker() {
        if (!this.table.existsNoQuotes() && !this.table.exists()) {
            return false;
        }
        this.createIfNotExists();
        try {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("type") + "='SCHEMA'", new String[0]);
            return count > 0;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check whether the metadata table " + this.table + " has a schema marker migration", e);
        }
    }

    @Override
    public boolean hasInitMarker() {
        if (!this.table.existsNoQuotes() && !this.table.exists()) {
            return false;
        }
        this.createIfNotExists();
        try {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("type") + "='INIT'", new String[0]);
            return count > 0;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check whether the metadata table " + this.table + " has an init marker migration", e);
        }
    }

    @Override
    public boolean hasAppliedMigrations() {
        if (!this.table.existsNoQuotes() && !this.table.exists()) {
            return false;
        }
        this.createIfNotExists();
        try {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.table + " WHERE " + this.dbSupport.quote("type") + " NOT IN ('SCHEMA', 'INIT')", new String[0]);
            return count > 0;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check whether the metadata table " + this.table + " has applied migrations", e);
        }
    }

    public String toString() {
        return this.table.toString();
    }
}

