/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.button;

import com.googlecode.wicket.jquery.core.IJsonFactory;
import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractButton
implements IJsonFactory,
IClusterable {
    private static final long serialVersionUID = 1L;
    private static short sequence = 0;
    public static final String EDIT = "edit";
    public static final String SAVE = "save";
    public static final String CREATE = "create";
    public static final String CANCEL = "cancel";
    public static final String DESTROY = "destroy";
    private final int id = AbstractButton.nextSequence();
    private final String name;
    private final IModel<String> text;
    private final String property;

    public AbstractButton(String name) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)name)), null);
    }

    public AbstractButton(String name, IModel<String> text) {
        this(name, text, null);
    }

    public AbstractButton(String name, String property) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)name)), property);
    }

    public AbstractButton(String name, IModel<String> text, String property) {
        this.name = name;
        this.text = text;
        this.property = property;
    }

    public String getName() {
        return this.name;
    }

    public IModel<String> getText() {
        return this.text;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public int hashCode() {
        return this.id;
    }

    public abstract boolean isBuiltIn();

    public boolean equals(Object object) {
        if (object instanceof AbstractButton) {
            return this.match(((AbstractButton)object).getName());
        }
        return super.equals(object);
    }

    public boolean match(String name) {
        return Strings.isEqual((String)name, (String)this.name);
    }

    private static synchronized int nextSequence() {
        short s = sequence;
        sequence = (short)(s + 1);
        return s % Short.MAX_VALUE;
    }
}

