/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.button;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.datatable.button.ToolbarButton;
import java.util.List;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;

public class ToolbarAjaxBehavior
extends JQueryAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final ToolbarButton button;

    public ToolbarAjaxBehavior(IJQueryAjaxAware source) {
        this(source, null);
    }

    public ToolbarAjaxBehavior(IJQueryAjaxAware source, ToolbarButton button) {
        super(source);
        this.button = (ToolbarButton)Args.notNull((Object)button, (String)"button");
    }

    public String getButtonName() {
        return this.button.getName();
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"values", (String)"values")};
    }

    public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
        String property = this.button.getProperty();
        String statement = "var values = [];\n";
        if (property != null) {
            statement = statement + "var $grid = jQuery(e.target).closest('.k-grid').data('kendoGrid');\n";
            statement = statement + "jQuery.each($grid.select(), function(index, row) { values.push($grid.dataItem(row)." + property + "); }\n";
            statement = statement + ");\n";
        }
        return statement + super.getCallbackFunctionBody(parameters);
    }

    protected JQueryEvent newEvent() {
        return new ToolbarClickEvent(this.button);
    }

    public static class ToolbarClickEvent
    extends JQueryEvent {
        private final ToolbarButton button;
        private final List<String> values;

        public ToolbarClickEvent(ToolbarButton button) {
            this.button = button;
            this.values = Generics.newArrayList();
            String values = RequestCycleUtils.getQueryParameterValue((String)"values").toString("");
            if (!Strings.isEmpty((CharSequence)values)) {
                for (String value : values.split(",")) {
                    this.values.add(value);
                }
            }
        }

        public ToolbarButton getButton() {
            return this.button;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

