/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.dataviz.diagram;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.dataviz.diagram.IDiagramListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class DiagramBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoDiagram";
    private final IDiagramListener listener;
    private KendoDataSource.HierarchicalDataSource dataSource;
    private JQueryAjaxBehavior onClickAjaxBehavior = null;

    public DiagramBehavior(String selector, IDiagramListener listener) {
        this(selector, new Options(), listener);
    }

    public DiagramBehavior(String selector, Options options, IDiagramListener listener) {
        super(selector, METHOD, options);
        this.listener = (IDiagramListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new KendoDataSource.HierarchicalDataSource(component);
        this.add(this.dataSource);
        if (this.listener.isClickEventEnabled()) {
            this.onClickAjaxBehavior = this.newOnClickAjaxBehavior(this);
            component.add(new Behavior[]{this.onClickAjaxBehavior});
        }
    }

    protected abstract CharSequence getProviderUrl();

    @Override
    public void onConfigure(Component component) {
        if (this.onClickAjaxBehavior != null) {
            this.setOption("click", this.onClickAjaxBehavior.getCallbackFunction());
        }
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.setTransportReadUrl(this.getProviderUrl());
        this.onConfigure(this.dataSource);
        super.onConfigure(component);
    }

    protected void onConfigure(KendoDataSource.HierarchicalDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ClickEvent) {
            this.listener.onClick(target, ((ClickEvent)event).getObject());
        }
    }

    protected JQueryAjaxBehavior newOnClickAjaxBehavior(IJQueryAjaxAware source) {
        return new OnClickAjaxBehavior(source);
    }

    protected static class ClickEvent
    extends JQueryEvent {
        private JSONObject object = null;

        public ClickEvent() {
            String data = RequestCycleUtils.getQueryParameterValue((String)"data").toString();
            if (!Strings.isEmpty((CharSequence)data)) {
                this.object = new JSONObject(data);
            }
        }

        public JSONObject getObject() {
            return this.object;
        }
    }

    protected static class OnClickAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnClickAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"data", (String)"kendo.stringify(e.item.dataItem)")};
        }

        protected JQueryEvent newEvent() {
            return new ClickEvent();
        }
    }
}

